/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.utils.builder;

import fr.maxlego08.zitemstacker.zcore.utils.builder.TimerBuilder;
import fr.maxlego08.zitemstacker.zcore.utils.storage.Persist;
import fr.maxlego08.zitemstacker.zcore.utils.storage.Savable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CooldownBuilder
implements Savable {
    public static Map<String, Map<UUID, Long>> cooldowns = new HashMap<String, Map<UUID, Long>>();
    private static transient CooldownBuilder i = new CooldownBuilder();

    public static Map<UUID, Long> getCooldownMap(String key) {
        return cooldowns.getOrDefault(key, null);
    }

    public static void clear() {
        cooldowns.clear();
    }

    public static void createCooldown(String key) {
        cooldowns.putIfAbsent(key, new HashMap());
    }

    public static void removeCooldown(String key, UUID uuid) {
        CooldownBuilder.createCooldown(key);
        CooldownBuilder.getCooldownMap(key).remove(uuid);
    }

    public static void removeCooldown(String key, Player player) {
        CooldownBuilder.removeCooldown(key, player.getUniqueId());
    }

    public static void addCooldown(String key, UUID uuid, int seconds) {
        CooldownBuilder.createCooldown(key);
        long next = System.currentTimeMillis() + (long)seconds * 1000L;
        CooldownBuilder.getCooldownMap(key).put(uuid, next);
    }

    public static void addCooldown(String key, Player player, int seconds) {
        CooldownBuilder.addCooldown(key, player.getUniqueId(), seconds);
    }

    public static boolean isCooldown(String key, UUID uuid) {
        CooldownBuilder.createCooldown(key);
        Map<UUID, Long> map = cooldowns.get(key);
        return map.containsKey(uuid) && System.currentTimeMillis() <= map.get(uuid);
    }

    public static boolean isCooldown(String key, Player player) {
        return CooldownBuilder.isCooldown(key, player.getUniqueId());
    }

    public static long getCooldown(String key, UUID uuid) {
        CooldownBuilder.createCooldown(key);
        Map<UUID, Long> map = cooldowns.get(key);
        return map.getOrDefault(uuid, 0L) - System.currentTimeMillis();
    }

    public static long getCooldownPlayer(String key, Player player) {
        return CooldownBuilder.getCooldown(key, player.getUniqueId());
    }

    public static String getCooldownAsString(String key, UUID player) {
        return TimerBuilder.getStringTime(CooldownBuilder.getCooldown(key, player) / 1000L);
    }

    @Override
    public void save(Persist persist) {
        persist.save((Object)i, "cooldowns");
    }

    @Override
    public void load(Persist persist) {
        persist.loadOrSaveDefault(i, CooldownBuilder.class, "cooldowns");
    }
}

