/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.utils.nms;

import fr.maxlego08.zitemstacker.zcore.utils.Base64;
import fr.maxlego08.zitemstacker.zcore.utils.nms.Base64ItemStack;
import fr.maxlego08.zitemstacker.zcore.utils.nms.NmsVersion;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.zip.GZIPInputStream;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class ItemStackUtils {
    private static final NmsVersion NMS_VERSION = NmsVersion.nmsVersion;

    public static String serializeItemStack(ItemStack paramItemStack) {
        if (paramItemStack == null) {
            return "null";
        }
        if (NmsVersion.getCurrentVersion().isAttributItemStack()) {
            return Base64ItemStack.encode(paramItemStack);
        }
        ByteArrayOutputStream localByteArrayOutputStream = null;
        try {
            Class<?> localClass = EnumReflectionItemStack.NBTTAGCOMPOUND.getClassz();
            Constructor<?> localConstructor = localClass.getConstructor(new Class[0]);
            Object localObject1 = localConstructor.newInstance(new Object[0]);
            Object localObject2 = EnumReflectionItemStack.CRAFTITEMSTACK.getClassz().getMethod("asNMSCopy", ItemStack.class).invoke(null, paramItemStack);
            if (NmsVersion.nmsVersion.isNewNBTVersion()) {
                EnumReflectionItemStack.ITEMSTACK.getClassz().getMethod("b", localClass).invoke(localObject2, localObject1);
            } else {
                EnumReflectionItemStack.ITEMSTACK.getClassz().getMethod("save", localClass).invoke(localObject2, localObject1);
            }
            localByteArrayOutputStream = new ByteArrayOutputStream();
            EnumReflectionItemStack.NBTCOMPRESSEDSTREAMTOOLS.getClassz().getMethod("a", localClass, OutputStream.class).invoke(null, localObject1, localByteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Base64.encode(localByteArrayOutputStream.toByteArray());
    }

    public static ItemStack deserializeItemStack(String paramString) {
        if (paramString == null || paramString.equals("null")) {
            return null;
        }
        if (NmsVersion.getCurrentVersion().isAttributItemStack()) {
            return Base64ItemStack.decode(paramString);
        }
        ByteArrayInputStream localByteArrayInputStream = null;
        try {
            localByteArrayInputStream = new ByteArrayInputStream(Base64.decode(paramString));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Class<?> localClass1 = EnumReflectionItemStack.NBTTAGCOMPOUND.getClassz();
        Class<?> localClass2 = EnumReflectionItemStack.ITEMSTACK.getClassz();
        Object localObject1 = null;
        ItemStack localItemStack = null;
        Object localObject2 = null;
        try {
            if (NmsVersion.nmsVersion == NmsVersion.V_1_20_4) {
                DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(localByteArrayInputStream)));
                localObject1 = EnumReflectionItemStack.NBTCOMPRESSEDSTREAMTOOLS.getClassz().getMethod("a", DataInput.class).invoke(null, datainputstream);
            } else {
                localObject1 = EnumReflectionItemStack.NBTCOMPRESSEDSTREAMTOOLS.getClassz().getMethod("a", InputStream.class).invoke(null, localByteArrayInputStream);
            }
            if (NMS_VERSION == NmsVersion.V_1_11 || NMS_VERSION == NmsVersion.V_1_12) {
                Constructor<?> localConstructor = localClass2.getConstructor(localClass1);
                localObject2 = localConstructor.newInstance(localObject1);
            } else {
                localObject2 = !NMS_VERSION.isItemLegacy() ? localClass2.getMethod("a", localClass1).invoke(null, localObject1) : localClass2.getMethod("createStack", localClass1).invoke(null, localObject1);
            }
            localItemStack = (ItemStack)EnumReflectionItemStack.CRAFTITEMSTACK.getClassz().getMethod("asBukkitCopy", localClass2).invoke(null, localObject2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localItemStack;
    }

    public static enum EnumReflectionItemStack {
        ITEMSTACK("ItemStack", "net.minecraft.world.item.ItemStack"),
        CRAFTITEMSTACK("inventory.CraftItemStack", true),
        NBTCOMPRESSEDSTREAMTOOLS("NBTCompressedStreamTools", "net.minecraft.nbt.NBTCompressedStreamTools"),
        NBTTAGCOMPOUND("NBTTagCompound", "net.minecraft.nbt.NBTTagCompound");

        private final String oldClassName;
        private final String newClassName;
        private final boolean isBukkit;

        private EnumReflectionItemStack(String oldClassName, String newClassName, boolean isBukkit) {
            this.oldClassName = oldClassName;
            this.newClassName = newClassName;
            this.isBukkit = isBukkit;
        }

        private EnumReflectionItemStack(String oldClassName, String newClassName) {
            this(oldClassName, newClassName, false);
        }

        private EnumReflectionItemStack(String oldClassName, boolean isBukkit) {
            this(oldClassName, null, isBukkit);
        }

        public Class<?> getClassz() {
            String nmsPackage = Bukkit.getServer().getClass().getPackage().getName();
            String nmsVersion = nmsPackage.replace(".", ",").split(",")[3];
            Object var3 = NmsVersion.nmsVersion.isNewNMSVersion() ? (this.isBukkit ? "org.bukkit.craftbukkit." + nmsVersion + "." + this.oldClassName : this.newClassName) : (this.isBukkit ? "org.bukkit.craftbukkit." : "net.minecraft.server.") + nmsVersion + "." + this.oldClassName;
            Class<?> localClass = null;
            try {
                localClass = Class.forName((String)var3);
            }
            catch (ClassNotFoundException localClassNotFoundException) {
                localClassNotFoundException.printStackTrace();
            }
            return localClass;
        }
    }
}

