/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.utils.plugins;

import fr.maxlego08.zitemstacker.zcore.enums.Message;
import fr.maxlego08.zitemstacker.zcore.logger.Logger;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class VersionChecker
implements Listener {
    private final String URL_API = "https://groupez.dev/api/v1/resource/version/%s";
    private final String URL_RESOURCE = "https://groupez.dev/resources/%s";
    private final Plugin plugin;
    private final int pluginID;
    private boolean isLastVersion = false;

    public VersionChecker(Plugin plugin, int pluginID) {
        this.plugin = plugin;
        this.pluginID = pluginID;
    }

    public void checkVersion() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
        String pluginVersion = this.plugin.getDescription().getVersion();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.getVersion(version -> {
            long ver = Long.parseLong(version.replace(".", ""));
            long plVersion = Long.parseLong(pluginVersion.replace(".", ""));
            atomicBoolean.set(plVersion >= ver);
            this.isLastVersion = atomicBoolean.get();
            if (atomicBoolean.get()) {
                Logger.info("No update available.");
            } else {
                Logger.info("New update available. Your version: " + pluginVersion + ", latest version: " + version);
                Logger.info("Download plugin here: " + String.format("https://groupez.dev/resources/%s", this.pluginID));
            }
        });
    }

    @EventHandler
    public void onConnect(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        if (!this.isLastVersion && event.getPlayer().hasPermission("zplugin.notifs")) {
            new BukkitRunnable(){

                public void run() {
                    String prefix = Message.PREFIX.getMessage();
                    player.sendMessage(prefix + "\u00a7cYou do not use the latest version of the plugin! Thank you for taking the latest version to avoid any risk of problem!");
                    player.sendMessage(prefix + "\u00a7fDownload plugin here: \u00a7a" + String.format("https://groupez.dev/resources/%s", VersionChecker.this.pluginID));
                }
            }.runTaskLater(this.plugin, 40L);
        }
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            String apiURL = String.format("https://groupez.dev/api/v1/resource/version/%s", this.pluginID);
            try {
                URL url = URI.create(apiURL).toURL();
                URLConnection hc = url.openConnection();
                hc.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
                Scanner scanner = new Scanner(hc.getInputStream());
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                }
                scanner.close();
            }
            catch (IOException exception) {
                this.plugin.getLogger().info("Cannot look for updates: " + exception.getMessage());
            }
        });
    }
}

