/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.utils.storage;

import fr.maxlego08.zitemstacker.zcore.ZPlugin;
import fr.maxlego08.zitemstacker.zcore.enums.Folder;
import fr.maxlego08.zitemstacker.zcore.logger.Logger;
import fr.maxlego08.zitemstacker.zcore.utils.ZUtils;
import fr.maxlego08.zitemstacker.zcore.utils.storage.DiscUtils;
import java.io.File;
import java.lang.reflect.Type;

public class Persist
extends ZUtils {
    private ZPlugin p;

    public Persist(ZPlugin p) {
        this.p = p;
    }

    public static String getName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public static String getName(Object o) {
        return Persist.getName(o.getClass());
    }

    public static String getName(Type type) {
        return Persist.getName(type.getClass());
    }

    public File getFile(String name) {
        return new File(this.p.getDataFolder(), name + ".json");
    }

    public File getFile(Class<?> clazz) {
        return this.getFile(Persist.getName(clazz));
    }

    public File getFile(Object obj) {
        return this.getFile(Persist.getName(obj));
    }

    public File getFile(Type type) {
        return this.getFile(Persist.getName(type));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(clazz));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, String name) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(name));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, Folder folder, String name) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(folder.toFolder() + File.separator + name));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, File file) {
        if (!file.exists()) {
            this.p.getLog().log("Creating default: " + String.valueOf(file), Logger.LogType.SUCCESS);
            this.save(def, file);
            return def;
        }
        T loaded = this.load(clazz, file);
        if (loaded == null) {
            this.p.getLog().log("Using default as I failed to load: " + String.valueOf(file), Logger.LogType.WARNING);
            File backup = new File(file.getPath() + "_bad");
            if (backup.exists()) {
                backup.delete();
            }
            this.p.getLog().log("Backing up copy of bad file to: " + String.valueOf(backup), Logger.LogType.WARNING);
            file.renameTo(backup);
            return def;
        }
        this.p.getLog().log(file.getAbsolutePath() + " loaded successfully !", Logger.LogType.SUCCESS);
        return loaded;
    }

    public boolean save(Object instance) {
        return this.save(instance, this.getFile(instance));
    }

    public boolean save(Object instance, String name) {
        return this.save(instance, this.getFile(name));
    }

    public boolean save(Object instance, Folder folder, String name) {
        return this.save(instance, this.getFile(folder.toFolder() + File.separator + name));
    }

    public boolean save(Object instance, File file) {
        try {
            boolean b = DiscUtils.writeCatch(file, this.p.getGson().toJson(instance));
            this.p.getLog().log(file.getAbsolutePath() + " successfully saved !", Logger.LogType.SUCCESS);
            return b;
        }
        catch (Exception e) {
            this.p.getLog().log("cannot save file " + file.getAbsolutePath(), Logger.LogType.ERROR);
            e.printStackTrace();
            return false;
        }
    }

    public <T> T load(Class<T> clazz) {
        return this.load(clazz, this.getFile(clazz));
    }

    public <T> T load(Class<T> clazz, String name) {
        return this.load(clazz, this.getFile(name));
    }

    public <T> T load(Class<T> clazz, File file) {
        String content = DiscUtils.readCatch(file);
        if (content == null) {
            return null;
        }
        try {
            Object instance = this.p.getGson().fromJson(content, clazz);
            return (T)instance;
        }
        catch (Exception ex) {
            this.p.getLog().log(ex.getMessage(), Logger.LogType.ERROR);
            return null;
        }
    }

    public <T> T load(Type typeOfT, String name) {
        return this.load(typeOfT, this.getFile(name));
    }

    public <T> T load(Type typeOfT, File file) {
        String content = DiscUtils.readCatch(file);
        if (content == null) {
            return null;
        }
        try {
            return (T)this.p.getGson().fromJson(content, typeOfT);
        }
        catch (Exception ex) {
            this.p.getLog().log(ex.getMessage(), Logger.LogType.ERROR);
            return null;
        }
    }
}

