/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.cache;

import io.github.gonalez.znpcs.cache.CacheCategory;
import io.github.gonalez.znpcs.utility.Utils;

public enum CachePackage {
    DEFAULT,
    CRAFT_BUKKIT("org.bukkit.craftbukkit"),
    MINECRAFT_SERVER("net.minecraft");

    private final String fixedPackageName;

    private CachePackage(String packageName) {
        if (packageName.endsWith("craftbukkit")) {
            String pckg = Utils.getBukkitPackage();
            if (!pckg.isEmpty()) {
                packageName = packageName + "." + Utils.getBukkitPackage();
            }
            this.fixedPackageName = packageName;
        } else {
            this.fixedPackageName = Utils.isVersionNew(17.0) ? packageName : packageName + (packageName.contains("minecraft") ? ".server." + Utils.getBukkitPackage() : "");
        }
    }

    private CachePackage() {
        this.fixedPackageName = "";
    }

    public String getForCategory(CacheCategory packetCategory, String extra) {
        return Utils.isVersionNew(17.0) ? packetCategory.getPackageName() + (!extra.isEmpty() ? "." + extra : "") : this.fixedPackageName;
    }

    public String getFixedPackageName() {
        return this.fixedPackageName;
    }
}

