/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.configuration;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.internal.;
import io.github.gonalez.znpcs.ServersNPC;
import io.github.gonalez.znpcs.configuration.ConfigurationValue;
import io.github.gonalez.znpcs.utility.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class Configuration {
    static final String CONFIG_FORMAT = ".json";
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final String name;
    private final Path path;
    private final Map<ConfigurationValue, Object> configurationValues;
    public static final Configuration CONFIGURATION = new Configuration("config");
    public static final Configuration MESSAGES = new Configuration("messages");
    public static final Configuration CONVERSATIONS = new Configuration("conversations");
    public static final Configuration DATA = new Configuration("data");
    public static final ImmutableList<Configuration> SAVE_CONFIGURATIONS = ImmutableList.of((Object)CONVERSATIONS, (Object)DATA);

    protected Configuration(String name) {
        this(name, ServersNPC.PLUGIN_FOLDER.toPath().resolve(name + CONFIG_FORMAT));
    }

    private Configuration(String name, Path path) {
        if (!path.getFileName().toString().endsWith(CONFIG_FORMAT)) {
            throw new IllegalStateException("invalid configuration format for: " + path.getFileName());
        }
        this.name = name;
        this.path = path;
        this.configurationValues = ConfigurationValue.VALUES_BY_NAME.get(name).stream().collect(Collectors.toMap(c -> c, ConfigurationValue::getValue));
        this.onLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLoad() {
        Path path = this.path;
        synchronized (path) {
            try {
                JsonElement data;
                BufferedReader reader;
                block19: {
                    block20: {
                        reader = Files.newBufferedReader(this.path, CHARSET);
                        data = JSON_PARSER.parse((Reader)reader);
                        if (data != null) break block19;
                        if (reader == null) break block20;
                        ((Reader)reader).close();
                    }
                    return;
                }
                try {
                    for (ConfigurationValue configValue : this.configurationValues.keySet()) {
                        boolean single;
                        boolean bl = single = this.configurationValues.size() == 1;
                        Object jsonElement = single ? data : (data.isJsonObject() ? data.getAsJsonObject().get(configValue.name()) : null);
                        if (jsonElement == null || jsonElement.isJsonNull()) continue;
                        if (!single && configValue.getPrimitiveType().isEnum()) {
                            this.configurationValues.put(configValue, ServersNPC.GSON.fromJson(jsonElement, configValue.getPrimitiveType()));
                            continue;
                        }
                        this.configurationValues.put(configValue, ServersNPC.GSON.fromJson(jsonElement, (Type).Gson.Types.newParameterizedTypeWithOwner(null, configValue.getValue().getClass(), (Type[])new Type[]{configValue.getPrimitiveType()})));
                    }
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable1) {
                            throwable.addSuppressed(throwable1);
                        }
                    }
                    throw throwable;
                }
            }
            catch (NoSuchFileException reader) {
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read config: " + this.name);
            }
            finally {
                this.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Path path = this.path;
        synchronized (path) {
            try {
                BufferedWriter writer = Files.newBufferedWriter(this.path, CHARSET, new OpenOption[0]);
                try {
                    ServersNPC.GSON.toJson(this.configurationValues.size() == 1 ? this.configurationValues.values().iterator().next() : this.configurationValues, (Appendable)writer);
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable1) {
                            throwable.addSuppressed(throwable1);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to save config: " + this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getValue(ConfigurationValue configValue) {
        Path path = this.path;
        synchronized (path) {
            return (T)this.configurationValues.get((Object)configValue);
        }
    }

    public void sendMessage(CommandSender sender, ConfigurationValue configValue, Object ... replaces) {
        sender.sendMessage(Utils.toColor(String.format((String)this.getValue(configValue), replaces)));
    }
}

