/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.npc;

import com.google.common.base.MoreObjects;
import io.github.gonalez.znpcs.ServersNPC;
import io.github.gonalez.znpcs.npc.event.ClickType;
import io.github.gonalez.znpcs.user.ZUser;
import io.github.gonalez.znpcs.utility.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class NPCAction {
    private final ActionType actionType;
    private final ClickType clickType;
    private final String action;
    private int delay;

    public NPCAction(ActionType actionType, ClickType clickType, String action, int delay) {
        this.actionType = actionType;
        this.clickType = clickType;
        this.action = action;
        this.delay = delay;
    }

    public NPCAction(String actionType, String action) {
        this(ActionType.valueOf(actionType), ClickType.DEFAULT, action, 0);
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    public String getAction() {
        return this.action;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public long getFixedDelay() {
        return 1000000000L * (long)this.delay;
    }

    public void run(ZUser user, String action) {
        this.actionType.run(user, Utils.PLACEHOLDER_SUPPORT ? Utils.getWithPlaceholders(action, user.toPlayer()) : action);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actionType", (Object)this.actionType).add("clickType", (Object)this.clickType).add("action", (Object)this.action).add("delay", this.delay).toString();
    }

    static enum ActionType {
        CMD{

            @Override
            public void run(ZUser user, String actionValue) {
                user.toPlayer().performCommand(actionValue);
            }
        }
        ,
        CONSOLE{

            @Override
            public void run(ZUser user, String actionValue) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)actionValue);
            }
        }
        ,
        CHAT{

            @Override
            public void run(ZUser user, String actionValue) {
                user.toPlayer().chat(actionValue);
            }
        }
        ,
        MESSAGE{

            @Override
            public void run(ZUser user, String actionValue) {
                user.toPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)actionValue));
            }
        }
        ,
        SERVER{

            @Override
            public void run(ZUser user, String actionValue) {
                ServersNPC.BUNGEE_UTILS.sendPlayerToServer(user.toPlayer(), actionValue);
            }
        };


        public abstract void run(ZUser var1, String var2);
    }
}

