/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.npc;

import io.github.gonalez.znpcs.utility.Utils;

public class NPCSkin {
    private static final String[] EMPTY_ARRAY = new String[]{"", ""};
    private static final int LAYER_INDEX = SkinLayerValues.findLayerByVersion();
    private final String texture;
    private final String signature;

    protected NPCSkin(String ... values) {
        if (values.length < 1) {
            throw new IllegalArgumentException("Length cannot be zero or negative.");
        }
        this.texture = values[0];
        this.signature = values[1];
    }

    public String getTexture() {
        return this.texture;
    }

    public String getSignature() {
        return this.signature;
    }

    public int getLayerIndex() {
        return LAYER_INDEX;
    }

    public static NPCSkin forValues(String ... values) {
        return new NPCSkin(values.length > 0 ? values : EMPTY_ARRAY);
    }

    static enum SkinLayerValues {
        V8(8.0, 10),
        V9(10.0, 13),
        V14(14.0, 15),
        V16(15.0, 16),
        V17(17.0, 17),
        V18(18.0, 17),
        V26(20.6, 17);

        final double minVersion;
        final int layerValue;

        private SkinLayerValues(double minVersion, int layerValue) {
            this.minVersion = minVersion;
            this.layerValue = layerValue;
        }

        static int findLayerByVersion() {
            int value = SkinLayerValues.V8.layerValue;
            for (SkinLayerValues skinLayerValue : SkinLayerValues.values()) {
                if (!Utils.isVersionNew(skinLayerValue.minVersion)) continue;
                value = skinLayerValue.layerValue;
            }
            return value;
        }
    }
}

