/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.npc.packet;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import io.github.gonalez.znpcs.cache.CacheRegistry;
import io.github.gonalez.znpcs.npc.FunctionFactory;
import io.github.gonalez.znpcs.npc.ItemSlot;
import io.github.gonalez.znpcs.npc.NPC;
import io.github.gonalez.znpcs.npc.NPCType;
import io.github.gonalez.znpcs.npc.packet.PacketCache;
import io.github.gonalez.znpcs.npc.packet.PacketValue;
import io.github.gonalez.znpcs.npc.packet.ValueType;
import io.github.gonalez.znpcs.utility.ReflectionUtils;
import io.github.gonalez.znpcs.utility.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public interface Packet {
    public double version();

    @PacketValue(keyName="playerPacket")
    public Object getPlayerPacket(Object var1, GameProfile var2) throws ReflectiveOperationException;

    @PacketValue(keyName="spawnPacket")
    public Object getSpawnPacket(int var1, UUID var2, Location var3, EntityType var4, Object var5) throws ReflectiveOperationException;

    public Object convertItemStack(int var1, ItemSlot var2, ItemStack var3) throws ReflectiveOperationException;

    public Object getClickType(Object var1) throws ReflectiveOperationException;

    public Object getMetadataPacket(int var1, Object var2) throws ReflectiveOperationException;

    @PacketValue(keyName="hologramSpawnPacket", valueType=ValueType.ARGUMENTS)
    public Object getHologramSpawnPacket(Object var1) throws ReflectiveOperationException;

    @PacketValue(keyName="destroyPacket", valueType=ValueType.ARGUMENTS)
    default public Object getDestroyPacket(int entityId) throws ReflectiveOperationException {
        Object object;
        Object[] objectArray = new Object[1];
        if (CacheRegistry.PACKET_PLAY_OUT_ENTITY_DESTROY_CONSTRUCTOR.load().getParameterTypes()[0].isArray()) {
            int[] nArray = new int[1];
            object = nArray;
            nArray[0] = entityId;
        } else {
            object = entityId;
        }
        objectArray[0] = object;
        return CacheRegistry.PACKET_PLAY_OUT_ENTITY_DESTROY_CONSTRUCTOR.load().newInstance(objectArray);
    }

    public Object getDatawatcherObject(Object var1) throws ReflectiveOperationException;

    public Object getTeleportPacket(int var1, Object var2) throws ReflectiveOperationException;

    @PacketValue(keyName="enumSlot", valueType=ValueType.ARGUMENTS)
    default public Object getItemSlot(int slot) {
        return CacheRegistry.ENUM_ITEM_SLOT.getEnumConstants()[slot];
    }

    @PacketValue(keyName="removeTab")
    default public Object getTabRemovePacket(Object nmsEntity) throws ReflectiveOperationException {
        try {
            return CacheRegistry.PACKET_PLAY_OUT_PLAYER_INFO_CONSTRUCTOR.load().newInstance(CacheRegistry.REMOVE_PLAYER_FIELD.load(), Collections.singletonList(nmsEntity));
        }
        catch (Throwable throwable) {
            boolean useOldMethod;
            boolean bl = useOldMethod = CacheRegistry.PACKET_PLAY_OUT_PLAYER_INFO_REMOVE_CLASS != null;
            if (useOldMethod) {
                return CacheRegistry.PACKET_PLAY_OUT_PLAYER_INFO_REMOVE_CONSTRUCTOR.load().newInstance(Collections.singletonList(CacheRegistry.GET_UNIQUE_ID_METHOD.load().invoke(nmsEntity, new Object[0])));
            }
            return CacheRegistry.PACKET_PLAY_OUT_PLAYER_INFO_CONSTRUCTOR.load().newInstance(CacheRegistry.REMOVE_PLAYER_FIELD.load(), nmsEntity);
        }
    }

    @PacketValue(keyName="equipPackets")
    public ImmutableList<Object> getEquipPackets(NPC var1) throws ReflectiveOperationException;

    @PacketValue(keyName="scoreboardPackets")
    default public ImmutableList<Object> updateScoreboard(NPC npc) throws ReflectiveOperationException {
        Collection collection;
        Object scoreboardTeamPacket;
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean isVersion17 = Utils.isVersionNew(17.0);
        boolean isVersion9 = Utils.isVersionNew(9.0);
        Object obj = scoreboardTeamPacket = isVersion17 ? CacheRegistry.SCOREBOARD_TEAM_CONSTRUCTOR.load().newInstance(null, npc.getGameProfile().getName()) : CacheRegistry.PACKET_PLAY_OUT_SCOREBOARD_TEAM_CONSTRUCTOR_OLD.load().newInstance(new Object[0]);
        if (!isVersion17) {
            Utils.setValue(scoreboardTeamPacket, "a", npc.getGameProfile().getName());
            Utils.setValue(scoreboardTeamPacket, isVersion9 ? "i" : "h", 1);
        }
        builder.add(isVersion17 ? CacheRegistry.PACKET_PLAY_OUT_SCOREBOARD_TEAM_CREATE_V1.load().invoke(null, scoreboardTeamPacket) : scoreboardTeamPacket);
        if (isVersion17) {
            scoreboardTeamPacket = CacheRegistry.SCOREBOARD_TEAM_CONSTRUCTOR.load().newInstance(null, npc.getGameProfile().getName());
            if (Utils.isVersionNew(18.0)) {
                Utils.setValue(scoreboardTeamPacket, "d", npc.getGameProfile().getName());
                ReflectionUtils.findFieldForClassAndSet(scoreboardTeamPacket, CacheRegistry.ENUM_TAG_VISIBILITY, CacheRegistry.ENUM_TAG_VISIBILITY_NEVER_FIELD.load());
                try {
                    Utils.setValue(scoreboardTeamPacket, "m", CacheRegistry.ENUM_CHAT_FORMAT_FIND.load().invoke(null, "DARK_GRAY"));
                }
                catch (Exception exception) {
                    Utils.setValue(scoreboardTeamPacket, "m", CacheRegistry.ENUM_CHAT_FORMAT_FIND.load().invoke(null, "darkgray"));
                }
            } else {
                Utils.setValue(scoreboardTeamPacket, "e", npc.getGameProfile().getName());
                Utils.setValue(scoreboardTeamPacket, "l", CacheRegistry.ENUM_TAG_VISIBILITY_NEVER_FIELD.load());
            }
        } else {
            scoreboardTeamPacket = CacheRegistry.PACKET_PLAY_OUT_SCOREBOARD_TEAM_CONSTRUCTOR_OLD.load().newInstance(new Object[0]);
            Utils.setValue(scoreboardTeamPacket, "a", npc.getGameProfile().getName());
            Utils.setValue(scoreboardTeamPacket, "e", "never");
            Utils.setValue(scoreboardTeamPacket, isVersion9 ? "i" : "h", 0);
        }
        Collection collection2 = isVersion17 ? (Collection)CacheRegistry.SCOREBOARD_PLAYER_LIST.load().invoke(scoreboardTeamPacket, new Object[0]) : (collection = (Collection)Utils.getValue(scoreboardTeamPacket, isVersion9 ? "h" : "g"));
        if (npc.getNpcPojo().getNpcType() == NPCType.PLAYER) {
            collection.add(npc.getGameProfile().getName());
        } else {
            collection.add(npc.getUUID().toString());
        }
        if (this.allowGlowColor() && FunctionFactory.isTrue(npc, "glow")) {
            this.updateGlowPacket(npc, scoreboardTeamPacket);
        }
        builder.add(isVersion17 ? CacheRegistry.PACKET_PLAY_OUT_SCOREBOARD_TEAM_CREATE.load().invoke(null, scoreboardTeamPacket, Boolean.TRUE) : scoreboardTeamPacket);
        return builder.build();
    }

    public void updateGlowPacket(NPC var1, Object var2) throws ReflectiveOperationException;

    public boolean allowGlowColor();

    default public void update(PacketCache packetCache) {
        packetCache.flushCache("scoreboardPackets");
    }
}

