/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.npc.packet;

import com.google.common.collect.ImmutableSet;
import io.github.gonalez.znpcs.npc.packet.Packet;
import io.github.gonalez.znpcs.npc.packet.PacketV16;
import io.github.gonalez.znpcs.npc.packet.PacketV17;
import io.github.gonalez.znpcs.npc.packet.PacketV18;
import io.github.gonalez.znpcs.npc.packet.PacketV19;
import io.github.gonalez.znpcs.npc.packet.PacketV21;
import io.github.gonalez.znpcs.npc.packet.PacketV213;
import io.github.gonalez.znpcs.npc.packet.PacketV8;
import io.github.gonalez.znpcs.npc.packet.PacketV9;
import io.github.gonalez.znpcs.utility.Utils;
import java.util.Comparator;

public final class PacketFactory {
    public static final ImmutableSet<Packet> ALL = ImmutableSet.of((Object)new PacketV8(), (Object)new PacketV9(), (Object)new PacketV16(), (Object)new PacketV17(), (Object)new PacketV18(), (Object)new PacketV19(), (Object[])new Packet[]{new PacketV21(), new PacketV213()});
    public static final Packet PACKET_FOR_CURRENT_VERSION = PacketFactory.findPacketForVersion();

    public static Packet findPacketForVersion() {
        return ALL.stream().filter(packet -> Utils.isVersionNew(packet.version())).max(Comparator.comparing(Packet::version)).orElseThrow(() -> new IllegalArgumentException("No packet instance found for version: " + Utils.BUKKIT_VERSION));
    }
}

