/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.skin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.github.gonalez.znpcs.skin.SkinFetchHttp;
import io.github.gonalez.znpcs.skin.SkinFetcherServer;
import io.github.gonalez.znpcs.skin.SkinProperties;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class SkinFetcher {
    private final Executor executor;
    private final ImmutableList<SkinFetcherServer> skinFetcherServers;

    public SkinFetcher(Executor executor, ImmutableList<SkinFetcherServer> skinFetcherServers) {
        this.executor = executor;
        this.skinFetcherServers = (ImmutableList)Preconditions.checkNotNull(skinFetcherServers);
    }

    public void fetchSkin(String name, SkinFetchListener listener) {
        this.executor.execute(() -> {
            LinkedList<SkinFetcherServer> serverQueue = new LinkedList<SkinFetcherServer>((Collection<SkinFetcherServer>)this.skinFetcherServers);
            this.fetchSkinInternal(serverQueue, name, listener);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSkinInternal(LinkedList<SkinFetcherServer> queue, String name, SkinFetchListener listener) {
        if (queue.isEmpty()) {
            listener.onError(new IOException("All SkinFetcherServers failed."));
            return;
        }
        SkinFetcherServer server = queue.poll();
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = server.createConnection(name);
            SkinFetchHttp.HttpResponse response = server.readHttpResponse(urlConnection);
            SkinProperties skinProperties = server.decodeProperties(response);
            listener.onSuccess(server, skinProperties);
        }
        catch (IOException e) {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            this.fetchSkinInternal(queue, name, listener);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static interface SkinFetchListener {
        default public void onSuccess(SkinFetcherServer server, SkinProperties skinProperties) {
        }

        default public void onError(Throwable throwable) {
        }
    }
}

