/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.utility;

import io.github.gonalez.znpcs.cache.CacheRegistry;
import io.github.gonalez.znpcs.configuration.ConfigurationConstants;
import io.github.gonalez.znpcs.user.ZUser;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public final class Utils {
    public static final double BUKKIT_VERSION;
    public static final boolean PLACEHOLDER_SUPPORT;

    public static boolean isPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException var1) {
            return false;
        }
    }

    public static double extractAndSumNumbers(String str) {
        Pattern pattern = Pattern.compile("(\\d+)");
        Matcher matcher = pattern.matcher(str);
        double[] numbers = new double[3];
        int count = 0;
        while (matcher.find() && count < 3) {
            numbers[count++] = Double.parseDouble(matcher.group());
        }
        return numbers[1] + numbers[2] / Math.pow(10.0, String.valueOf((int)numbers[2]).length());
    }

    public static boolean isVersionNew(double version) {
        return BUKKIT_VERSION >= version;
    }

    public static String getBukkitPackage() {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        String[] split = packageName.split("\\.");
        if (split.length > 3) {
            return split[3];
        }
        return "";
    }

    public static String toColor(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String getWithPlaceholders(String string, Player player) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)string).replace(ConfigurationConstants.SPACE_SYMBOL, " ");
    }

    public static String randomString(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < length; ++index) {
            stringBuilder.append(ThreadLocalRandom.current().nextInt(0, 9));
        }
        return stringBuilder.toString();
    }

    public static void sendTitle(Player player, String title, String subTitle) {
        player.sendTitle(Utils.toColor(title), Utils.toColor(subTitle));
    }

    public static void setValue(Object fieldInstance, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = fieldInstance.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(fieldInstance, value);
    }

    public static void setValue(Object fieldInstance, Object value, Class<?> expectedType) throws NoSuchFieldException, IllegalAccessException {
        for (Field field : fieldInstance.getClass().getDeclaredFields()) {
            if (field.getType() != expectedType) continue;
            Utils.setValue(fieldInstance, field.getName(), value);
        }
    }

    public static Object getValue(Object instance, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field f = instance.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        return f.get(instance);
    }

    public static void sendPackets(ZUser user, Object ... packets) {
        try {
            for (Object packet : packets) {
                if (packet == null) continue;
                CacheRegistry.SEND_PACKET_METHOD.load().invoke(user.getPlayerConnection(), packet);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        PLACEHOLDER_SUPPORT = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        BUKKIT_VERSION = Utils.extractAndSumNumbers(Bukkit.getBukkitVersion());
    }
}

