/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.completable;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.executor.Cancellable;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Completable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Completable.class);
    private final MultiThreadedQueue<BiConsumer<T, Throwable>> waiters = new MultiThreadedQueue();
    private T result;
    private Throwable throwable;
    private volatile boolean completed;

    public boolean isCompleted() {
        return this.completed;
    }

    public T getResult() {
        return this.result;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Cancellable addAsynchronousWaiter(BiConsumer<T, Throwable> consumer) {
        if (this.waiters.add(consumer)) {
            return new CancellableImpl(consumer);
        }
        return null;
    }

    private void completeAllWaiters(T result, Throwable throwable) {
        BiConsumer<T, Throwable> waiter;
        this.completed = true;
        while ((waiter = this.waiters.pollOrBlockAdds()) != null) {
            this.completeWaiter(waiter, result, throwable);
        }
    }

    private void completeWaiter(BiConsumer<T, Throwable> consumer, T result, Throwable throwable) {
        try {
            consumer.accept(result, throwable);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable throwable2) {
            LOGGER.error("Failed to complete callback " + ConcurrentUtil.genericToString(consumer), throwable2);
        }
    }

    public Cancellable addWaiter(BiConsumer<T, Throwable> consumer) {
        if (this.waiters.add(consumer)) {
            return new CancellableImpl(consumer);
        }
        this.completeWaiter(consumer, this.result, this.throwable);
        return new CancellableImpl(consumer);
    }

    public void complete(T result) {
        this.result = result;
        this.completeAllWaiters(result, null);
    }

    public void completeWithThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("Throwable cannot be null");
        }
        this.throwable = throwable;
        this.completeAllWaiters(null, throwable);
    }

    private final class CancellableImpl
    implements Cancellable {
        private final BiConsumer<T, Throwable> waiter;

        private CancellableImpl(BiConsumer<T, Throwable> waiter) {
            this.waiter = waiter;
        }

        @Override
        public boolean cancel() {
            return Completable.this.waiters.remove(this.waiter);
        }
    }
}

