/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.executor.standard;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrioritisedQueueExecutorThread
extends Thread
implements PrioritisedExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrioritisedQueueExecutorThread.class);
    protected final PrioritisedExecutor queue;
    protected volatile boolean threadShutdown;
    protected volatile boolean threadParked;
    protected static final VarHandle THREAD_PARKED_HANDLE = ConcurrentUtil.getVarHandle(PrioritisedQueueExecutorThread.class, "threadParked", Boolean.TYPE);
    protected volatile boolean halted;
    protected final long spinWaitTime;
    static final long DEFAULT_SPINWAIT_TIME = 100000L;

    public PrioritisedQueueExecutorThread(PrioritisedExecutor queue) {
        this(queue, 100000L);
    }

    public PrioritisedQueueExecutorThread(PrioritisedExecutor queue, long spinWaitTime) {
        this.queue = queue;
        this.spinWaitTime = spinWaitTime;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        spinWaitTime = this.spinWaitTime;
        block0: while (true) {
            this.pollTasks();
            start = System.nanoTime();
            do {
                Thread.interrupted();
                Thread.yield();
                LockSupport.parkNanos("Spinwaiting on tasks", 10000L);
                if (this.pollTasks()) continue block0;
                if (!this.handleClose()) continue;
                return;
            } while (System.nanoTime() - start < spinWaitTime);
            if (this.handleClose()) {
                return;
            }
            this.setThreadParkedVolatile(true);
            if (this.pollTasks()) {
                this.setThreadParkedVolatile(false);
                continue;
            }
            if (this.handleClose()) {
                return;
            }
            while (true) {
                if (this.getThreadParkedVolatile()) ** break;
                continue block0;
                Thread.interrupted();
                LockSupport.park("Waiting on tasks");
            }
            break;
        }
    }

    protected boolean pollTasks() {
        boolean ret = false;
        while (!this.halted) {
            try {
                if (!this.queue.executeTask()) break;
                ret = true;
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable throwable) {
                LOGGER.error("Exception thrown from prioritized runnable task in thread '" + this.getName() + "'", throwable);
            }
        }
        return ret;
    }

    protected boolean handleClose() {
        if (this.threadShutdown) {
            this.pollTasks();
            return true;
        }
        return false;
    }

    public boolean notifyTasks() {
        if (this.getThreadParkedVolatile() && this.exchangeThreadParkedVolatile(false)) {
            LockSupport.unpark(this);
            return true;
        }
        return false;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, PrioritisedExecutor.Priority priority) {
        final PrioritisedExecutor.PrioritisedTask queueTask = this.queue.createTask(task, priority);
        return new PrioritisedExecutor.PrioritisedTask(){

            @Override
            public PrioritisedExecutor.Priority getPriority() {
                return queueTask.getPriority();
            }

            @Override
            public boolean setPriority(PrioritisedExecutor.Priority priority) {
                return queueTask.setPriority(priority);
            }

            @Override
            public boolean raisePriority(PrioritisedExecutor.Priority priority) {
                return queueTask.raisePriority(priority);
            }

            @Override
            public boolean lowerPriority(PrioritisedExecutor.Priority priority) {
                return queueTask.lowerPriority(priority);
            }

            @Override
            public boolean queue() {
                boolean ret = queueTask.queue();
                if (ret) {
                    PrioritisedQueueExecutorThread.this.notifyTasks();
                }
                return ret;
            }

            @Override
            public boolean cancel() {
                return queueTask.cancel();
            }

            @Override
            public boolean execute() {
                return queueTask.execute();
            }
        };
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueRunnable(Runnable task, PrioritisedExecutor.Priority priority) {
        PrioritisedExecutor.PrioritisedTask ret = this.queue.queueRunnable(task, priority);
        this.notifyTasks();
        return ret;
    }

    @Override
    public boolean haveAllTasksExecuted() {
        return this.queue.haveAllTasksExecuted();
    }

    @Override
    public long getTotalTasksExecuted() {
        return this.queue.getTotalTasksExecuted();
    }

    @Override
    public long getTotalTasksScheduled() {
        return this.queue.getTotalTasksScheduled();
    }

    @Override
    public void waitUntilAllExecuted() throws IllegalStateException {
        if (Thread.currentThread() == this) {
            throw new IllegalStateException("Cannot block on our own queue");
        }
        this.queue.waitUntilAllExecuted();
    }

    @Override
    public boolean executeTask() throws IllegalStateException {
        throw new IllegalStateException();
    }

    public boolean close(boolean wait, boolean killQueue) {
        boolean ret = killQueue && this.queue.shutdown();
        this.threadShutdown = true;
        this.setThreadParkedVolatile(false);
        LockSupport.unpark(this);
        if (wait) {
            this.waitUntilAllExecuted();
        }
        return ret;
    }

    public void halt(boolean killQueue) {
        if (killQueue) {
            this.queue.shutdown();
        }
        this.threadShutdown = true;
        this.halted = true;
        this.setThreadParkedVolatile(false);
        LockSupport.unpark(this);
    }

    protected final boolean getThreadParkedVolatile() {
        return THREAD_PARKED_HANDLE.getVolatile(this);
    }

    protected final boolean exchangeThreadParkedVolatile(boolean value) {
        return THREAD_PARKED_HANDLE.getAndSet(this, value);
    }

    protected final void setThreadParkedVolatile(boolean value) {
        THREAD_PARKED_HANDLE.setVolatile(this, value);
    }
}

