/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.converters;

import java.util.Comparator;

public abstract class DataConverter<T, R> {
    public static final Comparator<DataConverter<?, ?>> LOWEST_VERSION_COMPARATOR = (x, y) -> Long.compare(x.getEncodedVersion(), y.getEncodedVersion());
    protected final int toVersion;
    protected final int versionStep;

    public DataConverter(int toVersion) {
        this.toVersion = toVersion;
        this.versionStep = 0;
    }

    public DataConverter(int toVersion, int versionStep) {
        this.toVersion = toVersion;
        this.versionStep = versionStep;
    }

    public final int getToVersion() {
        return this.toVersion;
    }

    public final int getVersionStep() {
        return this.versionStep;
    }

    public final long getEncodedVersion() {
        return DataConverter.encodeVersions(this.toVersion, this.versionStep);
    }

    public abstract R convert(T var1, long var2, long var4);

    public static long encodeVersions(int version, int step) {
        return (long)version << 32 | (long)step & 0xFFFFFFFFL;
    }

    public static int getVersion(long encoded) {
        return (int)(encoded >>> 32);
    }

    public static int getStep(long encoded) {
        return (int)encoded;
    }

    public static String encodedToString(long encoded) {
        return DataConverter.getVersion(encoded) + "." + DataConverter.getStep(encoded);
    }
}

