/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.stats;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.function.Function;

public final class ConverterAbstractStatsRename {
    private ConverterAbstractStatsRename() {
    }

    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractStatsRename.register(version, 0, renamer);
    }

    public static void register(int version, int subVersion, final Function<String, String> renamer) {
        MCTypeRegistry.OBJECTIVE.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(version, subVersion){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType criteriaType = data.getMap("CriteriaType");
                if (criteriaType == null) {
                    return null;
                }
                String type = criteriaType.getString("type");
                if (!"minecraft:custom".equals(type)) {
                    return null;
                }
                String id = criteriaType.getString("id");
                if (id == null) {
                    return null;
                }
                String rename = (String)renamer.apply(id);
                if (rename != null) {
                    criteriaType.setString("id", rename);
                }
                return null;
            }
        });
        MCTypeRegistry.STATS.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(version, subVersion){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType stats = data.getMap("stats");
                if (stats == null) {
                    return null;
                }
                MapType<String> custom = stats.getMap("minecraft:custom");
                if (custom == null) {
                    return null;
                }
                RenameHelper.renameKeys(custom, renamer);
                return null;
            }
        });
    }
}

