/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V1466 {
    private static final int VERSION = 1466;

    private static short packOffsetCoordinates(int x, int y, int z) {
        return (short)(x & 0xF | (y & 0xF) << 4 | (z & 0xF) << 8);
    }

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1466){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType ticks;
                boolean lightPopulated;
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                boolean terrainPopulated = level.getBoolean("TerrainPopulated");
                boolean bl = lightPopulated = level.getBoolean("LightPopulated") || level.getNumber("LightPopulated") == null;
                String newStatus = !terrainPopulated ? "carved" : (lightPopulated ? "mobs_spawned" : "decorated");
                level.setString("Status", newStatus);
                level.setBoolean("hasLegacyStructureData", true);
                byte[] biomes = level.getBytes("Biomes");
                if (biomes != null) {
                    int[] newBiomes = new int[256];
                    int len = Math.min(newBiomes.length, biomes.length);
                    for (int i = 0; i < len; ++i) {
                        newBiomes[i] = biomes[i] & 0xFF;
                    }
                    level.setInts("Biomes", newBiomes);
                }
                if ((ticks = level.getList("TileTicks", ObjectType.MAP)) != null) {
                    int i;
                    ListType sections = Types.NBT.createEmptyList();
                    ListType[] sectionAccess = new ListType[16];
                    for (i = 0; i < sectionAccess.length; ++i) {
                        sectionAccess[i] = Types.NBT.createEmptyList();
                        sections.addList(sectionAccess[i]);
                    }
                    level.setList("ToBeTicked", sections);
                    int len = ticks.size();
                    for (i = 0; i < len; ++i) {
                        MapType tick = ticks.getMap(i);
                        int x = tick.getInt("x");
                        int y = tick.getInt("y");
                        int z = tick.getInt("z");
                        short coordinate = V1466.packOffsetCoordinates(x, y, z);
                        sectionAccess[y >> 4].addShort(coordinate);
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.CHUNK.addStructureWalker(1466, (data, fromVersion, toVersion) -> {
            ListType sections;
            MapType<String> level = data.getMap("Level");
            if (level == null) {
                return null;
            }
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, level, "Entities", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.TILE_ENTITY, level, "TileEntities", fromVersion, toVersion);
            ListType tileTicks = level.getList("TileTicks", ObjectType.MAP);
            if (tileTicks != null) {
                int len = tileTicks.size();
                for (int i = 0; i < len; ++i) {
                    MapType<String> tileTick = tileTicks.getMap(i);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, tileTick, "i", fromVersion, toVersion);
                }
            }
            if ((sections = level.getList("Sections", ObjectType.MAP)) != null) {
                int len = sections.size();
                for (int i = 0; i < len; ++i) {
                    MapType<String> section = sections.getMap(i);
                    WalkerUtils.convertList(MCTypeRegistry.BLOCK_STATE, section, "Palette", fromVersion, toVersion);
                }
            }
            WalkerUtils.convertValues(MCTypeRegistry.STRUCTURE_FEATURE, level.getMap("Structures"), "Starts", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.STRUCTURE_FEATURE.addStructureWalker(1466, (data, fromVersion, toVersion) -> {
            ListType list = data.getList("Children", ObjectType.MAP);
            if (list != null) {
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    MapType<String> child = list.getMap(i);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_STATE, child, "CA", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_STATE, child, "CB", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_STATE, child, "CC", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_STATE, child, "CD", fromVersion, toVersion);
                }
            }
            WalkerUtils.convert(MCTypeRegistry.BIOME, (MapType<String>)data, "biome", fromVersion, toVersion);
            return null;
        });
    }

    private V1466() {
    }
}

