/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedThreadPool;
import io.papermc.paper.configuration.GlobalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoonriseCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoonriseCommon.class);
    public static PrioritisedThreadPool WORKER_POOL;
    public static int WORKER_THREADS;

    public static void init(GlobalConfiguration.ChunkSystem chunkSystem) {
        int defaultWorkerThreads = Runtime.getRuntime().availableProcessors() / 2;
        defaultWorkerThreads = defaultWorkerThreads <= 4 ? (defaultWorkerThreads <= 3 ? 1 : 2) : (defaultWorkerThreads /= 2);
        defaultWorkerThreads = Integer.getInteger("Paper.WorkerThreadCount", (Integer)defaultWorkerThreads);
        int workerThreads = chunkSystem.workerThreads;
        if (workerThreads <= 0) {
            workerThreads = defaultWorkerThreads;
        }
        WORKER_POOL = new PrioritisedThreadPool("Paper Worker Pool", workerThreads, (thread, id) -> {
            thread.setName("Paper Common Worker #" + id);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable);
                }
            });
        }, 20000000L);
        WORKER_THREADS = workerThreads;
    }

    private MoonriseCommon() {
    }
}

