/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(TickThread.class);
    public final int id;
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();

    @Deprecated
    public static void ensureTickThread(String reason) {
        if (!TickThread.isTickThread()) {
            LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Level world, BlockPos pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Level world, ChunkPos pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Level world, int chunkX, int chunkZ, String reason) {
        if (!TickThread.isTickThreadFor(world, chunkX, chunkZ)) {
            LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Entity entity, String reason) {
        if (!TickThread.isTickThreadFor(entity)) {
            LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Level world, AABB aabb, String reason) {
        if (!TickThread.isTickThreadFor(world, aabb)) {
            LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Level world, double blockX, double blockZ, String reason) {
        if (!TickThread.isTickThreadFor(world, blockX, blockZ)) {
            LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public TickThread(String name) {
        this((Runnable)null, name);
    }

    public TickThread(Runnable run, String name) {
        this(run, name, ID_GENERATOR.incrementAndGet());
    }

    private TickThread(Runnable run, String name, int id) {
        super(run, name);
        this.id = id;
    }

    public static TickThread getCurrentTickThread() {
        return (TickThread)Thread.currentThread();
    }

    public static boolean isTickThread() {
        return Thread.currentThread() instanceof TickThread;
    }

    public static boolean isShutdownThread() {
        return false;
    }

    public static boolean isTickThreadFor(Level world, BlockPos pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Level world, ChunkPos pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Level world, Vec3 pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Level world, int chunkX, int chunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Level world, AABB aabb) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Level world, double blockX, double blockZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Level world, Vec3 position, Vec3 deltaMovement, int buffer) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Level world, int fromChunkX, int fromChunkZ, int toChunkX, int toChunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Level world, int chunkX, int chunkZ, int radius) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Entity entity) {
        return TickThread.isTickThread();
    }
}

