/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.player;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.common.misc.AllocatingRateLimiter;
import ca.spottedleaf.moonrise.common.misc.SingleUserAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.util.ParallelSearchRadiusIteration;
import com.google.gson.JsonObject;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.packet.PlayerChunkUnloadEvent;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongHeapPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import org.bukkit.entity.Player;

public final class RegionizedPlayerChunkLoader {
    public static final TicketType<Long> PLAYER_TICKET = TicketType.create("chunk_system:player_ticket", Long::compareTo);
    public static final TicketType<Long> PLAYER_TICKET_DELAYED = TicketType.create("chunk_system:player_ticket_delayed", Long::compareTo, 100);
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int GENERATED_TICKET_LEVEL = 33;
    public static final int LOADED_TICKET_LEVEL = ChunkTaskScheduler.getTicketLevel(ChunkStatus.EMPTY);
    public static final int TICK_TICKET_LEVEL = 31;
    private final ServerLevel world;

    public static int getAPITickViewDistance(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        PlayerChunkLoaderData data = player.moonrise$getChunkLoader();
        if (data == null) {
            return level.moonrise$getPlayerChunkLoader().getAPITickDistance();
        }
        return data.lastTickDistance;
    }

    public static int getAPIViewDistance(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        PlayerChunkLoaderData data = player.moonrise$getChunkLoader();
        if (data == null) {
            return level.moonrise$getPlayerChunkLoader().getAPIViewDistance();
        }
        return data.lastLoadDistance - 1;
    }

    public static int getLoadViewDistance(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        PlayerChunkLoaderData data = player.moonrise$getChunkLoader();
        if (data == null) {
            return level.moonrise$getPlayerChunkLoader().getAPIViewDistance();
        }
        return data.lastLoadDistance - 1;
    }

    public static int getAPISendViewDistance(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        PlayerChunkLoaderData data = player.moonrise$getChunkLoader();
        if (data == null) {
            return level.moonrise$getPlayerChunkLoader().getAPISendViewDistance();
        }
        return data.lastSendDistance;
    }

    public RegionizedPlayerChunkLoader(ServerLevel world) {
        this.world = world;
    }

    public void addPlayer(ServerPlayer player) {
        TickThread.ensureTickThread(player, "Cannot add player to player chunk loader async");
        if (!player.moonrise$isRealPlayer()) {
            return;
        }
        if (player.moonrise$getChunkLoader() != null) {
            throw new IllegalStateException("Player is already added to player chunk loader");
        }
        PlayerChunkLoaderData loader = new PlayerChunkLoaderData(this.world, player);
        player.moonrise$setChunkLoader(loader);
        loader.add();
    }

    public void updatePlayer(ServerPlayer player) {
        PlayerChunkLoaderData loader = player.moonrise$getChunkLoader();
        if (loader != null) {
            loader.update();
            loader.world.moonrise$getNearbyPlayers().tickPlayer(player);
        }
    }

    public void removePlayer(ServerPlayer player) {
        TickThread.ensureTickThread(player, "Cannot remove player from player chunk loader async");
        if (!player.moonrise$isRealPlayer()) {
            return;
        }
        PlayerChunkLoaderData loader = player.moonrise$getChunkLoader();
        if (loader == null) {
            return;
        }
        loader.remove();
        player.moonrise$setChunkLoader(null);
    }

    public void setSendDistance(int distance) {
        this.world.moonrise$getViewDistanceHolder().setSendViewDistance(distance);
    }

    public void setLoadDistance(int distance) {
        this.world.moonrise$getViewDistanceHolder().setLoadViewDistance(distance);
    }

    public void setTickDistance(int distance) {
        this.world.moonrise$getViewDistanceHolder().setTickViewDistance(distance);
    }

    public int getAPITickDistance() {
        ViewDistances distances = this.world.moonrise$getViewDistanceHolder().getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance, -1, distances.loadViewDistance);
        return tickViewDistance;
    }

    public int getAPIViewDistance() {
        ViewDistances distances = this.world.moonrise$getViewDistanceHolder().getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance, -1, distances.loadViewDistance);
        int loadDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, -1, distances.loadViewDistance);
        return loadDistance - 1;
    }

    public int getAPISendViewDistance() {
        ViewDistances distances = this.world.moonrise$getViewDistanceHolder().getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance, -1, distances.loadViewDistance);
        int loadDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, -1, distances.loadViewDistance);
        int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadDistance, -1, -1, distances.sendViewDistance);
        return sendViewDistance;
    }

    public boolean isChunkSent(ServerPlayer player, int chunkX, int chunkZ, boolean borderOnly) {
        return borderOnly ? this.isChunkSentBorderOnly(player, chunkX, chunkZ) : this.isChunkSent(player, chunkX, chunkZ);
    }

    public boolean isChunkSent(ServerPlayer player, int chunkX, int chunkZ) {
        PlayerChunkLoaderData loader = player.moonrise$getChunkLoader();
        if (loader == null) {
            return false;
        }
        return loader.sentChunks.contains(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public boolean isChunkSentBorderOnly(ServerPlayer player, int chunkX, int chunkZ) {
        PlayerChunkLoaderData loader = player.moonrise$getChunkLoader();
        if (loader == null) {
            return false;
        }
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                if (loader.sentChunks.contains(CoordinateUtils.getChunkKey(dx + chunkX, dz + chunkZ))) continue;
                return true;
            }
        }
        return false;
    }

    public void tick() {
        TickThread.ensureTickThread("Cannot tick player chunk loader async");
        long currTime = System.nanoTime();
        for (ServerPlayer player : new ArrayList<ServerPlayer>(this.world.players())) {
            PlayerChunkLoaderData loader = player.moonrise$getChunkLoader();
            if (loader == null || loader.removed || loader.world != this.world) continue;
            loader.update();
            loader.updateQueues(currTime);
        }
    }

    public static final class PlayerChunkLoaderData {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        private final long id = ID_GENERATOR.incrementAndGet();
        private final Long idBoxed = this.id;
        private static final long MAX_RATE = 10000L;
        private final ServerPlayer player;
        private final ServerLevel world;
        private int lastChunkX = Integer.MIN_VALUE;
        private int lastChunkZ = Integer.MIN_VALUE;
        private int lastSendDistance = Integer.MIN_VALUE;
        private int lastLoadDistance = Integer.MIN_VALUE;
        private int lastTickDistance = Integer.MIN_VALUE;
        private int lastSentChunkCenterX = Integer.MIN_VALUE;
        private int lastSentChunkCenterZ = Integer.MIN_VALUE;
        private int lastSentChunkRadius = Integer.MIN_VALUE;
        private int lastSentSimulationDistance = Integer.MIN_VALUE;
        private boolean canGenerateChunks = true;
        private final ArrayDeque<ChunkHolderManager.TicketOperation<?, ?>> delayedTicketOps = new ArrayDeque();
        private final LongOpenHashSet sentChunks = new LongOpenHashSet();
        private static final byte CHUNK_TICKET_STAGE_NONE = 0;
        private static final byte CHUNK_TICKET_STAGE_LOADING = 1;
        private static final byte CHUNK_TICKET_STAGE_LOADED = 2;
        private static final byte CHUNK_TICKET_STAGE_GENERATING = 3;
        private static final byte CHUNK_TICKET_STAGE_GENERATED = 4;
        private static final byte CHUNK_TICKET_STAGE_TICK = 5;
        private static final int[] TICKET_STAGE_TO_LEVEL = new int[]{ChunkHolderManager.MAX_TICKET_LEVEL + 1, LOADED_TICKET_LEVEL, LOADED_TICKET_LEVEL, 33, 33, 31};
        private final Long2ByteOpenHashMap chunkTicketStage = new Long2ByteOpenHashMap();
        private static final long ALLOCATION_GRANULARITY = TimeUnit.SECONDS.toNanos(1L);
        private final AllocatingRateLimiter chunkSendLimiter;
        private final AllocatingRateLimiter chunkLoadTicketLimiter;
        private final AllocatingRateLimiter chunkGenerateTicketLimiter;
        private final LongComparator CLOSEST_MANHATTAN_DIST;
        private final LongHeapPriorityQueue sendQueue;
        private final LongHeapPriorityQueue tickingQueue;
        private final LongHeapPriorityQueue generatingQueue;
        private final LongHeapPriorityQueue genQueue;
        private final LongHeapPriorityQueue loadingQueue;
        private final LongHeapPriorityQueue loadQueue;
        private volatile boolean removed;
        private final SingleUserAreaMap<PlayerChunkLoaderData> broadcastMap;
        private final SingleUserAreaMap<PlayerChunkLoaderData> loadTicketCleanup;
        private final SingleUserAreaMap<PlayerChunkLoaderData> tickMap;

        public PlayerChunkLoaderData(ServerLevel world, ServerPlayer player) {
            this.chunkTicketStage.defaultReturnValue((byte)0);
            this.chunkSendLimiter = new AllocatingRateLimiter(ALLOCATION_GRANULARITY);
            this.chunkLoadTicketLimiter = new AllocatingRateLimiter(ALLOCATION_GRANULARITY);
            this.chunkGenerateTicketLimiter = new AllocatingRateLimiter(ALLOCATION_GRANULARITY);
            this.CLOSEST_MANHATTAN_DIST = (c1, c2) -> {
                int c1x = CoordinateUtils.getChunkX(c1);
                int c1z = CoordinateUtils.getChunkZ(c1);
                int c2x = CoordinateUtils.getChunkX(c2);
                int c2z = CoordinateUtils.getChunkZ(c2);
                int centerX = this.lastChunkX;
                int centerZ = this.lastChunkZ;
                return Integer.compare(Math.abs(c1x - centerX) + Math.abs(c1z - centerZ), Math.abs(c2x - centerX) + Math.abs(c2z - centerZ));
            };
            this.sendQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.tickingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.generatingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.genQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.loadingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.loadQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.broadcastMap = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    parameter.sendUnloadChunk(chunkX, chunkZ);
                }
            };
            this.loadTicketCleanup = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                    byte ticketStage = parameter.chunkTicketStage.remove(chunk);
                    int level = TICKET_STAGE_TO_LEVEL[ticketStage];
                    if (level > ChunkHolderManager.MAX_TICKET_LEVEL) {
                        return;
                    }
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunk, PLAYER_TICKET_DELAYED, level, parameter.idBoxed, PLAYER_TICKET, level, parameter.idBoxed));
                }
            };
            this.tickMap = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                    if (!parameter.chunkTicketStage.replace(chunk, (byte)5, (byte)4)) {
                        return;
                    }
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunk, PLAYER_TICKET_DELAYED, 31, parameter.idBoxed, PLAYER_TICKET, 31, parameter.idBoxed));
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addOp(chunk, PLAYER_TICKET, 33, parameter.idBoxed));
                }
            };
            this.world = world;
            this.player = player;
        }

        private void flushDelayedTicketOps() {
            if (this.delayedTicketOps.isEmpty()) {
                return;
            }
            this.world.moonrise$getChunkTaskScheduler().chunkHolderManager.performTicketUpdates(this.delayedTicketOps);
            this.delayedTicketOps.clear();
        }

        private void pushDelayedTicketOp(ChunkHolderManager.TicketOperation<?, ?> op) {
            this.delayedTicketOps.addLast(op);
        }

        private void sendChunk(int chunkX, int chunkZ) {
            if (this.sentChunks.add(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                this.world.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder((int)chunkX, (int)chunkZ).vanillaChunkHolder.moonrise$addReceivedChunk(this.player);
                PlayerChunkSender.sendChunk(this.player.connection, this.world, this.world.moonrise$getFullChunkIfLoaded(chunkX, chunkZ));
                return;
            }
            throw new IllegalStateException();
        }

        private void sendUnloadChunk(int chunkX, int chunkZ) {
            if (!this.sentChunks.remove(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                return;
            }
            this.sendUnloadChunkRaw(chunkX, chunkZ);
        }

        private void sendUnloadChunkRaw(int chunkX, int chunkZ) {
            this.world.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder((int)chunkX, (int)chunkZ).vanillaChunkHolder.moonrise$removeReceivedChunk(this.player);
            ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
            this.player.connection.send(new ClientboundForgetLevelChunkPacket(chunkPos));
            if (PlayerChunkUnloadEvent.getHandlerList().getRegisteredListeners().length > 0) {
                new PlayerChunkUnloadEvent(this.world.getWorld().getChunkAt(chunkPos.longKey), (Player)this.player.getBukkitEntity()).callEvent();
            }
        }

        private static boolean wantChunkLoaded(int centerX, int centerZ, int chunkX, int chunkZ, int sendRadius) {
            return ChunkTrackingView.isWithinDistance(centerX, centerZ, sendRadius, chunkX, chunkZ, true);
        }

        private static int getClientViewDistance(ServerPlayer player) {
            Integer vd = player.requestedViewDistance();
            return vd == null ? -1 : Math.max(0, vd);
        }

        private static int getTickDistance(int playerTickViewDistance, int worldTickViewDistance, int playerLoadViewDistance, int worldLoadViewDistance) {
            return Math.min(playerTickViewDistance < 0 ? worldTickViewDistance : playerTickViewDistance, playerLoadViewDistance < 0 ? worldLoadViewDistance : playerLoadViewDistance);
        }

        private static int getLoadViewDistance(int tickViewDistance, int playerLoadViewDistance, int worldLoadViewDistance) {
            return Math.max(tickViewDistance + 1, playerLoadViewDistance < 0 ? worldLoadViewDistance : playerLoadViewDistance);
        }

        private static int getSendViewDistance(int loadViewDistance, int clientViewDistance, int playerSendViewDistance, int worldSendViewDistance) {
            return Math.min(loadViewDistance - 1, playerSendViewDistance < 0 ? (!GlobalConfiguration.get().chunkLoadingAdvanced.autoConfigSendDistance || clientViewDistance < 0 ? (worldSendViewDistance < 0 ? loadViewDistance - 1 : worldSendViewDistance) : clientViewDistance + 1) : playerSendViewDistance);
        }

        private Packet<?> updateClientChunkRadius(int radius) {
            this.lastSentChunkRadius = radius;
            return new ClientboundSetChunkCacheRadiusPacket(radius);
        }

        private Packet<?> updateClientSimulationDistance(int distance) {
            this.lastSentSimulationDistance = distance;
            return new ClientboundSetSimulationDistancePacket(distance);
        }

        private Packet<?> updateClientChunkCenter(int chunkX, int chunkZ) {
            this.lastSentChunkCenterX = chunkX;
            this.lastSentChunkCenterZ = chunkZ;
            return new ClientboundSetChunkCacheCenterPacket(chunkX, chunkZ);
        }

        private boolean canPlayerGenerateChunks() {
            return !this.player.isSpectator() || this.world.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
        }

        private double getMaxChunkLoadRate() {
            double configRate = GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkLoadRate;
            return configRate <= 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private double getMaxChunkGenRate() {
            double configRate = GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkGenerateRate;
            return configRate <= 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private double getMaxChunkSendRate() {
            double configRate = GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkSendRate;
            return configRate <= 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private long getMaxChunkLoads() {
            long radiusChunks = (2L * (long)this.lastLoadDistance + 1L) * (2L * (long)this.lastLoadDistance + 1L);
            long configLimit = GlobalConfiguration.get().chunkLoadingAdvanced.playerMaxConcurrentChunkLoads;
            if (configLimit == 0L) {
                configLimit = Math.max(5L, radiusChunks / 5L);
            } else if (configLimit < 0L) {
                configLimit = Integer.MAX_VALUE;
            }
            return configLimit -= (long)this.loadingQueue.size();
        }

        private long getMaxChunkGenerates() {
            long radiusChunks = (2L * (long)this.lastLoadDistance + 1L) * (2L * (long)this.lastLoadDistance + 1L);
            long configLimit = GlobalConfiguration.get().chunkLoadingAdvanced.playerMaxConcurrentChunkGenerates;
            if (configLimit == 0L) {
                configLimit = Math.max(5L, radiusChunks / 5L);
            } else if (configLimit < 0L) {
                configLimit = Integer.MAX_VALUE;
            }
            return configLimit -= (long)this.generatingQueue.size();
        }

        private boolean wantChunkSent(int chunkX, int chunkZ) {
            int dx = this.lastChunkX - chunkX;
            int dz = this.lastChunkZ - chunkZ;
            return Math.max(Math.abs(dx), Math.abs(dz)) <= this.lastSendDistance + 1 && PlayerChunkLoaderData.wantChunkLoaded(this.lastChunkX, this.lastChunkZ, chunkX, chunkZ, this.lastSendDistance);
        }

        private boolean wantChunkTicked(int chunkX, int chunkZ) {
            int dx = this.lastChunkX - chunkX;
            int dz = this.lastChunkZ - chunkZ;
            return Math.max(Math.abs(dx), Math.abs(dz)) <= this.lastTickDistance;
        }

        private boolean areNeighboursGenerated(int chunkX, int chunkZ, int radius) {
            for (int dz = -radius; dz <= radius; ++dz) {
                for (int dx = -radius; dx <= radius; ++dx) {
                    long neighbour;
                    byte stage;
                    if ((dx | dz) == 0 || (stage = this.chunkTicketStage.get(neighbour = CoordinateUtils.getChunkKey(dx + chunkX, dz + chunkZ))) == 4 || stage == 5) continue;
                    return false;
                }
            }
            return true;
        }

        void updateQueues(long time) {
            int pendingChunkZ;
            long pendingTicking;
            int pendingChunkX;
            int pendingChunkZ2;
            long pendingGenChunk;
            int pendingChunkX2;
            LevelChunk pending;
            int pendingChunkZ3;
            long pendingLoadChunk;
            int pendingChunkX3;
            ChunkAccess pending2;
            TickThread.ensureTickThread(this.player, "Cannot tick player chunk loader async");
            if (this.removed) {
                throw new IllegalStateException("Ticking removed player chunk loader");
            }
            double loadRate = this.getMaxChunkLoadRate();
            double genRate = this.getMaxChunkGenRate();
            double sendRate = this.getMaxChunkSendRate();
            this.chunkLoadTicketLimiter.tickAllocation(time, loadRate, loadRate);
            this.chunkGenerateTicketLimiter.tickAllocation(time, genRate, genRate);
            this.chunkSendLimiter.tickAllocation(time, sendRate, sendRate);
            while (!this.loadingQueue.isEmpty() && (pending2 = this.world.moonrise$getAnyChunkIfLoaded(pendingChunkX3 = CoordinateUtils.getChunkX(pendingLoadChunk = this.loadingQueue.firstLong()), pendingChunkZ3 = CoordinateUtils.getChunkZ(pendingLoadChunk))) != null) {
                this.loadingQueue.dequeueLong();
                byte prev = this.chunkTicketStage.put(pendingLoadChunk, (byte)2);
                if (prev != 1) {
                    throw new IllegalStateException("Previous state should be 1, not " + prev);
                }
                if (!this.canGenerateChunks && !this.isLoadedChunkGeneratable(pending2)) continue;
                this.genQueue.enqueue(pendingLoadChunk);
            }
            long maxLoads = Math.max(0L, Math.min(10000L, Math.min((long)this.loadQueue.size(), this.getMaxChunkLoads())));
            int maxLoadsThisTick = (int)this.chunkLoadTicketLimiter.takeAllocation(time, loadRate, maxLoads);
            if (maxLoadsThisTick > 0) {
                int i;
                LongArrayList chunks = new LongArrayList(maxLoadsThisTick);
                for (i = 0; i < maxLoadsThisTick; ++i) {
                    long chunk = this.loadQueue.dequeueLong();
                    byte prev = this.chunkTicketStage.put(chunk, (byte)1);
                    if (prev != 0) {
                        throw new IllegalStateException("Previous state should be 0, not " + prev);
                    }
                    this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addOp(chunk, PLAYER_TICKET, LOADED_TICKET_LEVEL, this.idBoxed));
                    chunks.add(chunk);
                    this.loadingQueue.enqueue(chunk);
                }
                this.flushDelayedTicketOps();
                this.world.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
                if (this.removed) {
                    return;
                }
                for (i = 0; i < maxLoadsThisTick; ++i) {
                    long queuedLoadChunk = chunks.getLong(i);
                    int queuedChunkX = CoordinateUtils.getChunkX(queuedLoadChunk);
                    int queuedChunkZ = CoordinateUtils.getChunkZ(queuedLoadChunk);
                    this.world.moonrise$getChunkTaskScheduler().scheduleChunkLoad(queuedChunkX, queuedChunkZ, ChunkStatus.EMPTY, false, PrioritisedExecutor.Priority.NORMAL, null);
                    if (!this.removed) continue;
                    return;
                }
            }
            while (!this.generatingQueue.isEmpty() && (pending = this.world.moonrise$getFullChunkIfLoaded(pendingChunkX2 = CoordinateUtils.getChunkX(pendingGenChunk = this.generatingQueue.firstLong()), pendingChunkZ2 = CoordinateUtils.getChunkZ(pendingGenChunk))) != null) {
                this.generatingQueue.dequeueLong();
                byte prev = this.chunkTicketStage.put(pendingGenChunk, (byte)4);
                if (prev != 3) {
                    throw new IllegalStateException("Previous state should be 3, not " + prev);
                }
                if (this.wantChunkSent(pendingChunkX2, pendingChunkZ2)) {
                    this.sendQueue.enqueue(pendingGenChunk);
                }
                if (!this.wantChunkTicked(pendingChunkX2, pendingChunkZ2)) continue;
                this.tickingQueue.enqueue(pendingGenChunk);
            }
            long maxGens = Math.max(0L, Math.min(10000L, Math.min((long)this.genQueue.size(), this.getMaxChunkGenerates())));
            long maxGensThisTick = this.chunkGenerateTicketLimiter.previewAllocation(time, genRate, maxGens);
            long ratedGensThisTick = 0L;
            while (!this.genQueue.isEmpty()) {
                int chunkZ;
                long chunkKey = this.genQueue.firstLong();
                int chunkX = CoordinateUtils.getChunkX(chunkKey);
                ChunkAccess chunk = this.world.moonrise$getAnyChunkIfLoaded(chunkX, chunkZ = CoordinateUtils.getChunkZ(chunkKey));
                if (chunk.getPersistedStatus() != ChunkStatus.FULL) {
                    if (ratedGensThisTick + 1L > maxGensThisTick) break;
                    ++ratedGensThisTick;
                }
                this.genQueue.dequeueLong();
                byte prev = this.chunkTicketStage.put(chunkKey, (byte)3);
                if (prev != 2) {
                    throw new IllegalStateException("Previous state should be 2, not " + prev);
                }
                this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunkKey, PLAYER_TICKET, 33, this.idBoxed, PLAYER_TICKET, LOADED_TICKET_LEVEL, this.idBoxed));
                this.generatingQueue.enqueue(chunkKey);
            }
            this.chunkGenerateTicketLimiter.takeAllocation(time, genRate, ratedGensThisTick);
            while (!this.tickingQueue.isEmpty() && this.areNeighboursGenerated(pendingChunkX = CoordinateUtils.getChunkX(pendingTicking = this.tickingQueue.firstLong()), pendingChunkZ = CoordinateUtils.getChunkZ(pendingTicking), 2)) {
                this.tickingQueue.dequeueLong();
                this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(pendingTicking, PLAYER_TICKET, 31, this.idBoxed, PLAYER_TICKET, 33, this.idBoxed));
                byte prev = this.chunkTicketStage.put(pendingTicking, (byte)5);
                if (prev == 4) continue;
                throw new IllegalStateException("Previous state should be 4, not " + prev);
            }
            long maxSends = Math.max(0L, Math.min(10000L, Integer.MAX_VALUE));
            int maxSendsThisTick = Math.min((int)this.chunkSendLimiter.takeAllocation(time, sendRate, maxSends), this.sendQueue.size());
            for (int i = 0; i < maxSendsThisTick; ++i) {
                long pendingSend = this.sendQueue.firstLong();
                int pendingSendX = CoordinateUtils.getChunkX(pendingSend);
                int pendingSendZ = CoordinateUtils.getChunkZ(pendingSend);
                LevelChunk chunk = this.world.moonrise$getFullChunkIfLoaded(pendingSendX, pendingSendZ);
                if (!this.areNeighboursGenerated(pendingSendX, pendingSendZ, 1) || !TickThread.isTickThreadFor((Level)this.world, pendingSendX, pendingSendZ)) break;
                if (!chunk.moonrise$isPostProcessingDone()) {
                    chunk.postProcessGeneration();
                    if (this.removed || this.sendQueue.isEmpty() || this.sendQueue.firstLong() != pendingSend) {
                        return;
                    }
                }
                this.sendQueue.dequeueLong();
                this.sendChunk(pendingSendX, pendingSendZ);
                if (!this.removed) continue;
                return;
            }
            this.flushDelayedTicketOps();
        }

        void add() {
            TickThread.ensureTickThread(this.player, "Cannot add player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Adding removed player chunk loader");
            }
            ViewDistances playerDistances = this.player.moonrise$getViewDistanceHolder().getViewDistances();
            ViewDistances worldDistances = this.world.moonrise$getViewDistanceHolder().getViewDistances();
            int chunkX = this.player.chunkPosition().x;
            int chunkZ = this.player.chunkPosition().z;
            int tickViewDistance = PlayerChunkLoaderData.getTickDistance(playerDistances.tickViewDistance, worldDistances.tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int loadViewDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int clientViewDistance = PlayerChunkLoaderData.getClientViewDistance(this.player);
            int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadViewDistance, clientViewDistance, playerDistances.sendViewDistance, worldDistances.sendViewDistance);
            this.player.connection.send(this.updateClientChunkRadius(sendViewDistance));
            this.player.connection.send(this.updateClientSimulationDistance(tickViewDistance));
            this.broadcastMap.add(chunkX, chunkZ, sendViewDistance + 1);
            this.loadTicketCleanup.add(chunkX, chunkZ, loadViewDistance + 1);
            this.tickMap.add(chunkX, chunkZ, tickViewDistance);
            this.player.connection.send(this.updateClientChunkCenter(chunkX, chunkZ));
            long time = System.nanoTime();
            this.chunkLoadTicketLimiter.reset(time);
            this.chunkGenerateTicketLimiter.reset(time);
            this.chunkSendLimiter.reset(time);
            this.update();
        }

        private boolean isLoadedChunkGeneratable(int chunkX, int chunkZ) {
            return this.isLoadedChunkGeneratable(this.world.moonrise$getAnyChunkIfLoaded(chunkX, chunkZ));
        }

        private boolean isLoadedChunkGeneratable(ChunkAccess chunkAccess) {
            BelowZeroRetrogen belowZeroRetrogen;
            return chunkAccess != null && (chunkAccess.getPersistedStatus() == ChunkStatus.FULL || (belowZeroRetrogen = chunkAccess.getBelowZeroRetrogen()) != null && belowZeroRetrogen.targetStatus().isOrAfter(ChunkStatus.SPAWN));
        }

        void update() {
            long[] toIterate;
            TickThread.ensureTickThread(this.player, "Cannot update player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Updating removed player chunk loader");
            }
            ViewDistances playerDistances = this.player.moonrise$getViewDistanceHolder().getViewDistances();
            ViewDistances worldDistances = this.world.moonrise$getViewDistanceHolder().getViewDistances();
            int tickViewDistance = PlayerChunkLoaderData.getTickDistance(playerDistances.tickViewDistance, worldDistances.tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int loadViewDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int clientViewDistance = PlayerChunkLoaderData.getClientViewDistance(this.player);
            int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadViewDistance, clientViewDistance, playerDistances.sendViewDistance, worldDistances.sendViewDistance);
            ChunkPos playerPos = this.player.chunkPosition();
            boolean canGenerateChunks = this.canPlayerGenerateChunks();
            int currentChunkX = playerPos.x;
            int currentChunkZ = playerPos.z;
            int prevChunkX = this.lastChunkX;
            int prevChunkZ = this.lastChunkZ;
            if (sendViewDistance == this.lastSendDistance && loadViewDistance == this.lastLoadDistance && tickViewDistance == this.lastTickDistance && prevChunkX == currentChunkX && prevChunkZ == currentChunkZ && this.canGenerateChunks == canGenerateChunks) {
                return;
            }
            this.broadcastMap.update(currentChunkX, currentChunkZ, sendViewDistance + 1);
            this.loadTicketCleanup.update(currentChunkX, currentChunkZ, loadViewDistance + 1);
            this.tickMap.update(currentChunkX, currentChunkZ, tickViewDistance);
            if (sendViewDistance > loadViewDistance || tickViewDistance > loadViewDistance) {
                throw new IllegalStateException();
            }
            if (this.lastSentChunkRadius != sendViewDistance) {
                this.player.connection.send(this.updateClientChunkRadius(sendViewDistance));
            }
            if (this.lastSentSimulationDistance != tickViewDistance) {
                this.player.connection.send(this.updateClientSimulationDistance(tickViewDistance));
            }
            this.sendQueue.clear();
            this.tickingQueue.clear();
            this.generatingQueue.clear();
            this.genQueue.clear();
            this.loadingQueue.clear();
            this.loadQueue.clear();
            this.lastChunkX = currentChunkX;
            this.lastChunkZ = currentChunkZ;
            this.lastSendDistance = sendViewDistance;
            this.lastLoadDistance = loadViewDistance;
            this.lastTickDistance = tickViewDistance;
            this.canGenerateChunks = canGenerateChunks;
            block8: for (long deltaChunk : toIterate = ParallelSearchRadiusIteration.getSearchIteration(loadViewDistance + 1)) {
                boolean sentChunk;
                int dx = CoordinateUtils.getChunkX(deltaChunk);
                int dz = CoordinateUtils.getChunkZ(deltaChunk);
                int chunkX = dx + currentChunkX;
                int chunkZ = dz + currentChunkZ;
                long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                int squareDistance = Math.max(Math.abs(dx), Math.abs(dz));
                int manhattanDistance = Math.abs(dx) + Math.abs(dz);
                boolean sendChunk = squareDistance <= sendViewDistance + 1 && PlayerChunkLoaderData.wantChunkLoaded(currentChunkX, currentChunkZ, chunkX, chunkZ, sendViewDistance);
                boolean bl = sentChunk = sendChunk ? this.sentChunks.contains(chunk) : this.sentChunks.remove(chunk);
                if (!sendChunk && sentChunk) {
                    this.sendUnloadChunkRaw(chunkX, chunkZ);
                }
                byte stage = this.chunkTicketStage.get(chunk);
                switch (stage) {
                    case 0: {
                        this.loadQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 1: {
                        this.loadingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 2: {
                        if (!canGenerateChunks && !this.isLoadedChunkGeneratable(chunkX, chunkZ)) continue block8;
                        this.genQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 3: {
                        this.generatingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 4: {
                        if (sendChunk && !sentChunk) {
                            this.sendQueue.enqueue(chunk);
                        }
                        if (squareDistance > tickViewDistance) continue block8;
                        this.tickingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 5: {
                        if (!sendChunk || sentChunk) continue block8;
                        this.sendQueue.enqueue(chunk);
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException("Unknown stage: " + stage);
                    }
                }
            }
            if (this.lastSentChunkCenterX != currentChunkX || this.lastSentChunkCenterZ != currentChunkZ) {
                this.player.connection.send(this.updateClientChunkCenter(currentChunkX, currentChunkZ));
            }
            this.flushDelayedTicketOps();
        }

        void remove() {
            TickThread.ensureTickThread(this.player, "Cannot add player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Removing removed player chunk loader");
            }
            this.removed = true;
            this.broadcastMap.remove();
            this.loadTicketCleanup.remove();
            this.tickMap.remove();
            this.sendQueue.clear();
            this.tickingQueue.clear();
            this.generatingQueue.clear();
            this.genQueue.clear();
            this.loadingQueue.clear();
            this.loadQueue.clear();
            this.flushDelayedTicketOps();
        }

        public LongOpenHashSet getSentChunksRaw() {
            return this.sentChunks;
        }
    }

    public static final class ViewDistanceHolder {
        private volatile ViewDistances viewDistances;
        private static final VarHandle VIEW_DISTANCES_HANDLE = ConcurrentUtil.getVarHandle(ViewDistanceHolder.class, "viewDistances", ViewDistances.class);

        public ViewDistanceHolder() {
            VIEW_DISTANCES_HANDLE.setVolatile(this, new ViewDistances(-1, -1, -1));
        }

        public ViewDistances getViewDistances() {
            return VIEW_DISTANCES_HANDLE.getVolatile(this);
        }

        public ViewDistances compareAndExchangeViewDistance(ViewDistances expect, ViewDistances update) {
            return VIEW_DISTANCES_HANDLE.compareAndExchange(this, expect, update);
        }

        public void updateViewDistance(Function<ViewDistances, ViewDistances> update) {
            int failures = 0;
            ViewDistances curr = this.getViewDistances();
            while (true) {
                for (int i = 0; i < failures; ++i) {
                    ConcurrentUtil.backoff();
                }
                if (curr == (curr = this.compareAndExchangeViewDistance(curr, update.apply(curr)))) {
                    return;
                }
                ++failures;
            }
        }

        public void setTickViewDistance(int distance) {
            this.updateViewDistance(param -> param.setTickViewDistance(distance));
        }

        public void setLoadViewDistance(int distance) {
            this.updateViewDistance(param -> param.setLoadViewDistance(distance));
        }

        public void setSendViewDistance(int distance) {
            this.updateViewDistance(param -> param.setTickViewDistance(distance));
        }

        public JsonObject toJson() {
            return this.getViewDistances().toJson();
        }
    }

    public record ViewDistances(int tickViewDistance, int loadViewDistance, int sendViewDistance) {
        public ViewDistances setTickViewDistance(int distance) {
            return new ViewDistances(distance, this.loadViewDistance, this.sendViewDistance);
        }

        public ViewDistances setLoadViewDistance(int distance) {
            return new ViewDistances(this.tickViewDistance, distance, this.sendViewDistance);
        }

        public ViewDistances setSendViewDistance(int distance) {
            return new ViewDistances(this.tickViewDistance, this.loadViewDistance, distance);
        }

        public JsonObject toJson() {
            JsonObject ret = new JsonObject();
            ret.addProperty("tick-view-distance", (Number)this.tickViewDistance);
            ret.addProperty("load-view-distance", (Number)this.loadViewDistance);
            ret.addProperty("send-view-distance", (Number)this.sendViewDistance);
            return ret;
        }
    }
}

