/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.queue;

import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class ChunkUnloadQueue {
    public final int coordinateShift;
    private final AtomicLong orderGenerator = new AtomicLong();
    private final ConcurrentLong2ReferenceChainedHashTable<UnloadSection> unloadSections = new ConcurrentLong2ReferenceChainedHashTable();

    public ChunkUnloadQueue(int coordinateShift) {
        this.coordinateShift = coordinateShift;
    }

    public List<SectionToUnload> retrieveForAllRegions() {
        ArrayList<SectionToUnload> ret = new ArrayList<SectionToUnload>();
        Iterator<ConcurrentLong2ReferenceChainedHashTable.TableEntry<UnloadSection>> iterator = this.unloadSections.entryIterator();
        while (iterator.hasNext()) {
            ConcurrentLong2ReferenceChainedHashTable.TableEntry<UnloadSection> entry = iterator.next();
            long key = entry.getKey();
            UnloadSection section = entry.getValue();
            int sectionX = CoordinateUtils.getChunkX(key);
            int sectionZ = CoordinateUtils.getChunkZ(key);
            ret.add(new SectionToUnload(sectionX, sectionZ, section.order, section.chunks.size()));
        }
        ret.sort((s1, s2) -> Long.compare(s1.order, s2.order));
        return ret;
    }

    public UnloadSection getSectionUnsynchronized(int sectionX, int sectionZ) {
        return this.unloadSections.get(CoordinateUtils.getChunkKey(sectionX, sectionZ));
    }

    public UnloadSection removeSection(int sectionX, int sectionZ) {
        return this.unloadSections.remove(CoordinateUtils.getChunkKey(sectionX, sectionZ));
    }

    public boolean addChunk(int chunkX, int chunkZ) {
        int shift = this.coordinateShift;
        int sectionX = chunkX >> shift;
        int sectionZ = chunkZ >> shift;
        long sectionKey = CoordinateUtils.getChunkKey(sectionX, sectionZ);
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        UnloadSection section = this.unloadSections.get(sectionKey);
        if (section == null) {
            section = new UnloadSection(this.orderGenerator.getAndIncrement());
            this.unloadSections.put(sectionKey, section);
        }
        return section.chunks.add(chunkKey);
    }

    public boolean removeChunk(int chunkX, int chunkZ) {
        int shift = this.coordinateShift;
        int sectionX = chunkX >> shift;
        int sectionZ = chunkZ >> shift;
        long sectionKey = CoordinateUtils.getChunkKey(sectionX, sectionZ);
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        UnloadSection section = this.unloadSections.get(sectionKey);
        if (section == null) {
            return false;
        }
        if (!section.chunks.remove(chunkKey)) {
            return false;
        }
        if (section.chunks.isEmpty()) {
            this.unloadSections.remove(sectionKey);
        }
        return true;
    }

    public JsonElement toDebugJson() {
        JsonArray ret = new JsonArray();
        for (SectionToUnload section : this.retrieveForAllRegions()) {
            JsonObject sectionJson = new JsonObject();
            ret.add((JsonElement)sectionJson);
            sectionJson.addProperty("sectionX", (Number)section.sectionX());
            sectionJson.addProperty("sectionZ", (Number)section.sectionX());
            sectionJson.addProperty("order", (Number)section.order());
            JsonArray coordinates = new JsonArray();
            sectionJson.add("coordinates", (JsonElement)coordinates);
            UnloadSection actualSection = this.getSectionUnsynchronized(section.sectionX(), section.sectionZ());
            if (actualSection == null) continue;
            LongListIterator iterator = actualSection.chunks.clone().iterator();
            while (iterator.hasNext()) {
                long coordinate = iterator.nextLong();
                JsonObject coordinateJson = new JsonObject();
                coordinates.add((JsonElement)coordinateJson);
                coordinateJson.addProperty("chunkX", (Number)CoordinateUtils.getChunkX(coordinate));
                coordinateJson.addProperty("chunkZ", (Number)CoordinateUtils.getChunkZ(coordinate));
            }
        }
        return ret;
    }

    public static final class UnloadSection {
        public final long order;
        public final LongLinkedOpenHashSet chunks = new LongLinkedOpenHashSet();

        public UnloadSection(long order) {
            this.order = order;
        }
    }

    public record SectionToUnload(int sectionX, int sectionZ, long order, int count) {
    }
}

