/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.starlight.util;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import com.mojang.logging.LogUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public final class SaveUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int STARLIGHT_LIGHT_VERSION = 9;
    private static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    private static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    private static final String STARLIGHT_VERSION_TAG = "starlight.light_version";

    public static int getLightVersion() {
        return 9;
    }

    public static void saveLightHook(Level world, ChunkAccess chunk, CompoundTag nbt) {
        try {
            SaveUtil.saveLightHookReal(world, chunk, nbt);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to inject light data into save data for chunk " + String.valueOf(chunk.getPos()) + ", chunk light will be recalculated on its next load", ex);
        }
    }

    private static void saveLightHookReal(Level world, ChunkAccess chunk, CompoundTag tag) {
        int i;
        boolean lit;
        if (tag == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        SWMRNibbleArray[] blockNibbles = chunk.starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.starlight$getSkyNibbles();
        boolean bl = lit = chunk.isLightCorrect() || !(world instanceof ServerLevel);
        if (lit) {
            tag.putBoolean("isLightOn", false);
        }
        ChunkStatus status = ChunkStatus.byName(tag.getString("Status"));
        CompoundTag[] sections = new CompoundTag[maxSection - minSection + 1];
        ListTag sectionsStored = tag.getList("sections", 10);
        for (i = 0; i < sectionsStored.size(); ++i) {
            CompoundTag sectionStored = sectionsStored.getCompound(i);
            byte k = sectionStored.getByte("Y");
            sectionStored.remove("BlockLight");
            sectionStored.remove("SkyLight");
            if (sectionStored.isEmpty()) continue;
            sections[k - minSection] = sectionStored;
        }
        if (lit && status.isOrAfter(ChunkStatus.LIGHT)) {
            for (i = minSection; i <= maxSection; ++i) {
                SWMRNibbleArray.SaveState blockNibble = blockNibbles[i - minSection].getSaveState();
                SWMRNibbleArray.SaveState skyNibble = skyNibbles[i - minSection].getSaveState();
                if (blockNibble == null && skyNibble == null) continue;
                CompoundTag section = sections[i - minSection];
                if (section == null) {
                    section = new CompoundTag();
                    section.putByte("Y", (byte)i);
                    sections[i - minSection] = section;
                }
                if (blockNibble != null) {
                    if (blockNibble.data != null) {
                        section.putByteArray("BlockLight", blockNibble.data);
                    }
                    section.putInt(BLOCKLIGHT_STATE_TAG, blockNibble.state);
                }
                if (skyNibble == null) continue;
                if (skyNibble.data != null) {
                    section.putByteArray("SkyLight", skyNibble.data);
                }
                section.putInt(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
        }
        sectionsStored.clear();
        for (CompoundTag section : sections) {
            if (section == null) continue;
            sectionsStored.add(section);
        }
        tag.put("sections", sectionsStored);
        if (lit) {
            tag.putInt(STARLIGHT_VERSION_TAG, 9);
        }
    }

    public static void loadLightHook(Level world, ChunkPos pos, CompoundTag tag, ChunkAccess into) {
        try {
            SaveUtil.loadLightHookReal(world, pos, tag, into);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to load light for chunk " + String.valueOf(pos) + ", light will be recalculated", ex);
        }
    }

    private static void loadLightHookReal(Level world, ChunkPos pos, CompoundTag tag, ChunkAccess into) {
        if (into == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        into.setLightCorrect(false);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        boolean lit = tag.get("isLightOn") != null && tag.getInt(STARLIGHT_VERSION_TAG) == 9;
        boolean canReadSky = world.dimensionType().hasSkyLight();
        ChunkStatus status = ChunkStatus.byName(tag.getString("Status"));
        if (lit && status.isOrAfter(ChunkStatus.LIGHT)) {
            ListTag sections = tag.getList("sections", 10);
            for (int i = 0; i < sections.size(); ++i) {
                CompoundTag sectionData = sections.getCompound(i);
                byte y = sectionData.getByte("Y");
                blockNibbles[y - minSection] = sectionData.contains("BlockLight", 7) ? new SWMRNibbleArray((byte[])sectionData.getByteArray("BlockLight").clone(), sectionData.getInt(BLOCKLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.getInt(BLOCKLIGHT_STATE_TAG));
                if (!canReadSky) continue;
                skyNibbles[y - minSection] = sectionData.contains("SkyLight", 7) ? new SWMRNibbleArray((byte[])sectionData.getByteArray("SkyLight").clone(), sectionData.getInt(SKYLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.getInt(SKYLIGHT_STATE_TAG));
            }
        }
        into.starlight$setBlockNibbles(blockNibbles);
        into.starlight$setSkyNibbles(skyNibbles);
        into.setLightCorrect(lit);
    }

    private SaveUtil() {
    }
}

