/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.brigadier.exceptions;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.BuiltInExceptions;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import io.papermc.paper.brigadier.PaperBrigadier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.ComponentMessageThrowable;
import org.jetbrains.annotations.Nullable;

public class CommandSyntaxException
extends Exception
implements ComponentMessageThrowable {
    public static final int CONTEXT_AMOUNT = 10;
    public static boolean ENABLE_COMMAND_STACK_TRACES = true;
    public static BuiltInExceptionProvider BUILT_IN_EXCEPTIONS = new BuiltInExceptions();
    private final CommandExceptionType type;
    private final Message message;
    private final String input;
    private final int cursor;

    public CommandSyntaxException(CommandExceptionType type, Message message) {
        super(message.getString(), null, ENABLE_COMMAND_STACK_TRACES, ENABLE_COMMAND_STACK_TRACES);
        this.type = type;
        this.message = message;
        this.input = null;
        this.cursor = -1;
    }

    public CommandSyntaxException(CommandExceptionType type, Message message, String input, int cursor) {
        super(message.getString(), null, ENABLE_COMMAND_STACK_TRACES, ENABLE_COMMAND_STACK_TRACES);
        this.type = type;
        this.message = message;
        this.input = input;
        this.cursor = cursor;
    }

    @Override
    public String getMessage() {
        Object message = this.message.getString();
        String context = this.getContext();
        if (context != null) {
            message = (String)message + " at position " + this.cursor + ": " + context;
        }
        return message;
    }

    public Message getRawMessage() {
        return this.message;
    }

    public String getContext() {
        if (this.input == null || this.cursor < 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int cursor = Math.min(this.input.length(), this.cursor);
        if (cursor > 10) {
            builder.append("...");
        }
        builder.append(this.input.substring(Math.max(0, cursor - 10), cursor));
        builder.append("<--[HERE]");
        return builder.toString();
    }

    public CommandExceptionType getType() {
        return this.type;
    }

    public String getInput() {
        return this.input;
    }

    public int getCursor() {
        return this.cursor;
    }

    @Nullable
    public Component componentMessage() {
        return PaperBrigadier.componentFromMessage((Message)this.message);
    }
}

