/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import com.destroystokyo.paper.util.SneakyThrow;
import io.papermc.paper.command.PaperSubcommand;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public final class DumpListenersCommand
implements PaperSubcommand {
    private static final MethodHandle EVENT_TYPES_HANDLE;

    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        if (args.length >= 1 && args[0].equals("tofile")) {
            this.dumpToFile(sender);
            return true;
        }
        this.doDumpListeners(sender, args);
        return true;
    }

    private void dumpToFile(CommandSender sender) {
        File file = new File("debug/listeners-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + ".txt");
        file.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(file);){
            for (String eventClass : DumpListenersCommand.eventClassNames()) {
                HandlerList handlers;
                try {
                    handlers = (HandlerList)DumpListenersCommand.findClass(eventClass).getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    continue;
                }
                if (handlers.getRegisteredListeners().length != 0) {
                    writer.println(eventClass);
                }
                for (RegisteredListener registeredListener : handlers.getRegisteredListeners()) {
                    writer.println(" - " + String.valueOf(registeredListener));
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        sender.sendMessage((Component)Component.text((String)("Dumped listeners to " + String.valueOf(file)), (TextColor)NamedTextColor.GREEN));
    }

    private void doDumpListeners(CommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage((Component)Component.text((String)"Usage: /paper dumplisteners tofile|<className>", (TextColor)NamedTextColor.RED));
            return;
        }
        try {
            HandlerList handlers = (HandlerList)DumpListenersCommand.findClass(args[0]).getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            if (handlers.getRegisteredListeners().length == 0) {
                sender.sendMessage((Component)Component.text((String)(args[0] + " does not have any registered listeners.")));
                return;
            }
            sender.sendMessage((Component)Component.text((String)("Listeners for " + args[0] + ":")));
            for (RegisteredListener listener : handlers.getRegisteredListeners()) {
                Component hoverText = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)("Priority: " + listener.getPriority().name() + " (" + listener.getPriority().getSlot() + ")"), (TextColor)NamedTextColor.WHITE).append((Component)Component.newline())).append((Component)Component.text((String)("Listener: " + String.valueOf(listener.getListener()))))).append((Component)Component.newline())).append((Component)Component.text((String)("Executor: " + String.valueOf(listener.getExecutor()))))).append((Component)Component.newline())).append((Component)Component.text((String)("Ignoring cancelled: " + listener.isIgnoringCancelled())));
                sender.sendMessage(((TextComponent)Component.text((String)listener.getPlugin().getName(), (TextColor)NamedTextColor.GREEN).append((Component)Component.space())).append(Component.text((String)("(" + listener.getListener().getClass().getName() + ")"), (TextColor)NamedTextColor.GRAY).hoverEvent((HoverEventSource)hoverText)));
            }
            sender.sendMessage((Component)Component.text((String)("Total listeners: " + handlers.getRegisteredListeners().length)));
        }
        catch (ClassNotFoundException e) {
            sender.sendMessage((Component)Component.text((String)("Unable to find a class named '" + args[0] + "'. Make sure to use the fully qualified name."), (TextColor)NamedTextColor.RED));
        }
        catch (NoSuchMethodException e) {
            sender.sendMessage((Component)Component.text((String)("Class '" + args[0] + "' does not have a valid getHandlerList method."), (TextColor)NamedTextColor.RED));
        }
        catch (ReflectiveOperationException e) {
            sender.sendMessage((Component)Component.text((String)"Something went wrong, see the console for more details.", (TextColor)NamedTextColor.RED));
            MinecraftServer.LOGGER.warn("Error occurred while dumping listeners for class " + args[0], (Throwable)e);
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        return switch (args.length) {
            case 0 -> DumpListenersCommand.suggestions();
            case 1 -> DumpListenersCommand.suggestions().stream().filter(clazz -> clazz.toLowerCase(Locale.ROOT).contains(args[0].toLowerCase(Locale.ROOT))).toList();
            default -> Collections.emptyList();
        };
    }

    private static List<String> suggestions() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("tofile");
        ret.addAll(DumpListenersCommand.eventClassNames());
        return ret;
    }

    private static Set<String> eventClassNames() {
        try {
            return EVENT_TYPES_HANDLE.invokeExact();
        }
        catch (Throwable e) {
            SneakyThrow.sneaky((Throwable)e);
            return Collections.emptySet();
        }
    }

    private static Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignore) {
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                if (!plugin.isEnabled()) continue;
                try {
                    return Class.forName(className, false, plugin.getClass().getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(className);
        }
    }

    static {
        try {
            Field eventTypesField = HandlerList.class.getDeclaredField("EVENT_TYPES");
            eventTypesField.setAccessible(true);
            EVENT_TYPES_HANDLE = MethodHandles.lookup().unreflectGetter(eventTypesField);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

