/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer.collections;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public abstract class FastutilMapSerializer<M extends Map<?, ?>>
implements TypeSerializer<M> {
    private final Function<Map, ? extends M> factory;

    protected FastutilMapSerializer(Function<Map, ? extends M> factory) {
        this.factory = factory;
    }

    public M deserialize(Type type, ConfigurationNode node) throws SerializationException {
        @Nullable Map map = (Map)node.get(this.createBaseMapType((ParameterizedType)type));
        return (M)((Map)this.factory.apply(map == null ? Collections.emptyMap() : map));
    }

    public void serialize(Type type, @Nullable M obj, ConfigurationNode node) throws SerializationException {
        if (obj == null || obj.isEmpty()) {
            node.raw(null);
        } else {
            Type baseMapType = this.createBaseMapType((ParameterizedType)type);
            node.set(baseMapType, obj);
        }
    }

    protected abstract Type createBaseMapType(ParameterizedType var1);

    public static final class PrimitiveToSomething<M extends Map<?, ?>>
    extends FastutilMapSerializer<M> {
        private final Type primitiveType;

        public PrimitiveToSomething(Function<Map, ? extends M> factory, Type primitiveType) {
            super(factory);
            this.primitiveType = primitiveType;
        }

        @Override
        protected Type createBaseMapType(ParameterizedType type) {
            return TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{GenericTypeReflector.box((Type)this.primitiveType), type.getActualTypeArguments()[0]});
        }
    }

    public static final class SomethingToPrimitive<M extends Map<?, ?>>
    extends FastutilMapSerializer<M> {
        private final Type primitiveType;

        public SomethingToPrimitive(Function<Map, ? extends M> factory, Type primitiveType) {
            super(factory);
            this.primitiveType = primitiveType;
        }

        @Override
        protected Type createBaseMapType(ParameterizedType type) {
            return TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{type.getActualTypeArguments()[0], GenericTypeReflector.box((Type)this.primitiveType)});
        }
    }
}

