/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datapack;

import io.papermc.paper.datapack.Datapack;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.Pack;

public class PaperDatapack
implements Datapack {
    private final String name;
    private final Datapack.Compatibility compatibility;
    private final boolean enabled;

    PaperDatapack(Pack loader, boolean enabled) {
        this.name = loader.getId();
        this.compatibility = Datapack.Compatibility.valueOf((String)loader.getCompatibility().name());
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public Datapack.Compatibility getCompatibility() {
        return this.compatibility;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        List<String> enabledKeys = server.getPackRepository().getSelectedPacks().stream().map(Pack::getId).collect(Collectors.toList());
        if (enabled) {
            enabledKeys.add(this.name);
        } else {
            enabledKeys.remove(this.name);
        }
        server.reloadResources(enabledKeys, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }
}

