/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.classloader;

import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.classloader.ClassloaderBytecodeModifier;
import io.papermc.paper.plugin.util.NamespaceChecker;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PaperSimplePluginClassLoader
extends URLClassLoader {
    protected final PluginMeta configuration;
    protected final Path source;
    protected final Manifest jarManifest;
    protected final URL jarUrl;
    protected final JarFile jar;

    public PaperSimplePluginClassLoader(Path source, JarFile file, PluginMeta configuration, ClassLoader parentLoader) throws IOException {
        super(source.getFileName().toString(), new URL[]{source.toUri().toURL()}, parentLoader);
        this.source = source;
        this.jarManifest = file.getManifest();
        this.jarUrl = source.toUri().toURL();
        this.configuration = configuration;
        this.jar = file;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes;
        JarEntry entry;
        block15: {
            String pkgName;
            NamespaceChecker.validateNameSpaceForClassloading(name);
            String path = name.replace('.', '/').concat(".class");
            entry = this.jar.getJarEntry(path);
            if (entry == null) {
                throw new ClassNotFoundException(name);
            }
            try (InputStream is = this.jar.getInputStream(entry);){
                classBytes = is.readAllBytes();
            }
            catch (IOException ex) {
                throw new ClassNotFoundException(name, ex);
            }
            classBytes = ClassloaderBytecodeModifier.bytecodeModifier().modify(this.configuration, classBytes);
            int dot = name.lastIndexOf(46);
            if (dot != -1 && this.getDefinedPackage(pkgName = name.substring(0, dot)) == null) {
                try {
                    if (this.jarManifest != null) {
                        this.definePackage(pkgName, this.jarManifest, this.jarUrl);
                    } else {
                        this.definePackage(pkgName, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (this.getDefinedPackage(pkgName) != null) break block15;
                    throw new IllegalStateException("Cannot find package " + pkgName);
                }
            }
        }
        CodeSigner[] signers = entry.getCodeSigners();
        CodeSource source = new CodeSource(this.jarUrl, signers);
        return this.defineClass(name, classBytes, 0, classBytes.length, source);
    }

    public String toString() {
        return "PaperSimplePluginClassLoader{configuration=" + String.valueOf(this.configuration) + ", source=" + String.valueOf(this.source) + ", jarManifest=" + String.valueOf(this.jarManifest) + ", jarUrl=" + String.valueOf(this.jarUrl) + ", jar=" + String.valueOf(this.jar) + "}";
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

