/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.lifecycle.event.registrar;

import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import io.papermc.paper.plugin.lifecycle.event.PaperLifecycleEvent;
import io.papermc.paper.plugin.lifecycle.event.registrar.PaperRegistrar;
import io.papermc.paper.plugin.lifecycle.event.registrar.RegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.OwnerAwareLifecycleEvent;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RegistrarEventImpl<R extends PaperRegistrar<? super O>, O extends LifecycleEventOwner>
implements PaperLifecycleEvent,
OwnerAwareLifecycleEvent<O>,
RegistrarEvent<R> {
    private final R registrar;
    private final Class<? extends O> ownerClass;

    public RegistrarEventImpl(R registrar, Class<? extends O> ownerClass) {
        this.registrar = registrar;
        this.ownerClass = ownerClass;
    }

    public R registrar() {
        return this.registrar;
    }

    @Override
    public final void setOwner(@Nullable O owner) {
        this.registrar.setCurrentContext(owner);
    }

    @Override
    public final @Nullable O castOwner(LifecycleEventOwner owner) {
        return (O)(this.ownerClass.isInstance(owner) ? (LifecycleEventOwner)this.ownerClass.cast(owner) : null);
    }

    @Override
    public void invalidate() {
        this.registrar.invalidate();
    }

    public String toString() {
        return "RegistrarEventImpl{registrar=" + String.valueOf(this.registrar) + ", ownerClass=" + String.valueOf(this.ownerClass) + "}";
    }

    public static class ReloadableImpl<R extends PaperRegistrar<? super O>, O extends LifecycleEventOwner>
    extends RegistrarEventImpl<R, O>
    implements ReloadableRegistrarEvent<R> {
        private final ReloadableRegistrarEvent.Cause cause;

        public ReloadableImpl(R registrar, Class<? extends O> ownerClass, ReloadableRegistrarEvent.Cause cause) {
            super(registrar, ownerClass);
            this.cause = cause;
        }

        public ReloadableRegistrarEvent.Cause cause() {
            return this.cause;
        }

        @Override
        public String toString() {
            return "ReloadableImpl{cause=" + String.valueOf(this.cause) + "} " + super.toString();
        }
    }
}

