/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public class EntitySubPredicates {
    public static final MapCodec<LightningBoltPredicate> LIGHTNING = EntitySubPredicates.register("lightning", LightningBoltPredicate.CODEC);
    public static final MapCodec<FishingHookPredicate> FISHING_HOOK = EntitySubPredicates.register("fishing_hook", FishingHookPredicate.CODEC);
    public static final MapCodec<PlayerPredicate> PLAYER = EntitySubPredicates.register("player", PlayerPredicate.CODEC);
    public static final MapCodec<SlimePredicate> SLIME = EntitySubPredicates.register("slime", SlimePredicate.CODEC);
    public static final MapCodec<RaiderPredicate> RAIDER = EntitySubPredicates.register("raider", RaiderPredicate.CODEC);
    public static final EntityVariantPredicateType<Axolotl.Variant> AXOLOTL = EntitySubPredicates.register("axolotl", EntityVariantPredicateType.create(Axolotl.Variant.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            optional = Optional.of(axolotl.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Boat.Type> BOAT = EntitySubPredicates.register("boat", EntityVariantPredicateType.create(Boat.Type.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            optional = Optional.of(boat.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Fox.Type> FOX = EntitySubPredicates.register("fox", EntityVariantPredicateType.create(Fox.Type.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            optional = Optional.of(fox.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<MushroomCow.MushroomType> MOOSHROOM = EntitySubPredicates.register("mooshroom", EntityVariantPredicateType.create(MushroomCow.MushroomType.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof MushroomCow) {
            MushroomCow mushroomCow = (MushroomCow)entity;
            optional = Optional.of(mushroomCow.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Rabbit.Variant> RABBIT = EntitySubPredicates.register("rabbit", EntityVariantPredicateType.create(Rabbit.Variant.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            optional = Optional.of(rabbit.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Variant> HORSE = EntitySubPredicates.register("horse", EntityVariantPredicateType.create(Variant.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            optional = Optional.of(horse.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Llama.Variant> LLAMA = EntitySubPredicates.register("llama", EntityVariantPredicateType.create(Llama.Variant.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            optional = Optional.of(llama.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<VillagerType> VILLAGER = EntitySubPredicates.register("villager", EntityVariantPredicateType.create(BuiltInRegistries.VILLAGER_TYPE.byNameCodec(), entity -> {
        Optional<Object> optional;
        if (entity instanceof VillagerDataHolder) {
            VillagerDataHolder villagerDataHolder = (VillagerDataHolder)((Object)entity);
            optional = Optional.of(villagerDataHolder.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Parrot.Variant> PARROT = EntitySubPredicates.register("parrot", EntityVariantPredicateType.create(Parrot.Variant.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            optional = Optional.of(parrot.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<TropicalFish.Pattern> TROPICAL_FISH = EntitySubPredicates.register("tropical_fish", EntityVariantPredicateType.create(TropicalFish.Pattern.CODEC, entity -> {
        Optional<Object> optional;
        if (entity instanceof TropicalFish) {
            TropicalFish tropicalFish = (TropicalFish)entity;
            optional = Optional.of(tropicalFish.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<PaintingVariant> PAINTING = EntitySubPredicates.register("painting", EntityHolderVariantPredicateType.create(Registries.PAINTING_VARIANT, entity -> {
        Optional<Object> optional;
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            optional = Optional.of(painting.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<CatVariant> CAT = EntitySubPredicates.register("cat", EntityHolderVariantPredicateType.create(Registries.CAT_VARIANT, entity -> {
        Optional<Object> optional;
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            optional = Optional.of(cat.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<FrogVariant> FROG = EntitySubPredicates.register("frog", EntityHolderVariantPredicateType.create(Registries.FROG_VARIANT, entity -> {
        Optional<Object> optional;
        if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            optional = Optional.of(frog.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<WolfVariant> WOLF = EntitySubPredicates.register("wolf", EntityHolderVariantPredicateType.create(Registries.WOLF_VARIANT, entity -> {
        Optional<Object> optional;
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            optional = Optional.of(wolf.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));

    private static <T extends EntitySubPredicate> MapCodec<T> register(String id, MapCodec<T> codec) {
        return Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, id, codec);
    }

    private static <V> EntityVariantPredicateType<V> register(String id, EntityVariantPredicateType<V> type) {
        Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, id, type.codec);
        return type;
    }

    private static <V> EntityHolderVariantPredicateType<V> register(String id, EntityHolderVariantPredicateType<V> type) {
        Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, id, type.codec);
        return type;
    }

    public static MapCodec<? extends EntitySubPredicate> bootstrap(Registry<MapCodec<? extends EntitySubPredicate>> registry) {
        return LIGHTNING;
    }

    public static EntitySubPredicate catVariant(Holder<CatVariant> catVariant) {
        return CAT.createPredicate(HolderSet.direct(catVariant));
    }

    public static EntitySubPredicate frogVariant(Holder<FrogVariant> frogVariant) {
        return FROG.createPredicate(HolderSet.direct(frogVariant));
    }

    public static EntitySubPredicate wolfVariant(HolderSet<WolfVariant> wolfVariant) {
        return WOLF.createPredicate(wolfVariant);
    }

    public static class EntityVariantPredicateType<V> {
        final MapCodec<Instance> codec;
        final Function<Entity, Optional<V>> getter;

        public static <V> EntityVariantPredicateType<V> create(Registry<V> registry, Function<Entity, Optional<V>> variantGetter) {
            return new EntityVariantPredicateType<V>(registry.byNameCodec(), variantGetter);
        }

        public static <V> EntityVariantPredicateType<V> create(Codec<V> codec, Function<Entity, Optional<V>> variantGetter) {
            return new EntityVariantPredicateType<V>(codec, variantGetter);
        }

        public EntityVariantPredicateType(Codec<V> variantCodec, Function<Entity, Optional<V>> variantGetter) {
            this.getter = variantGetter;
            this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)variantCodec.fieldOf("variant").forGetter(predicate -> predicate.variant)).apply((Applicative)instance, variant -> new Instance(variant)));
        }

        public EntitySubPredicate createPredicate(V variant) {
            return new Instance(variant);
        }

        class Instance
        implements EntitySubPredicate {
            final V variant;

            Instance(V variant) {
                this.variant = variant;
            }

            @Override
            public MapCodec<Instance> codec() {
                return EntityVariantPredicateType.this.codec;
            }

            @Override
            @Override
            public boolean matches(Entity entity, ServerLevel world, @Nullable Vec3 pos) {
                return EntityVariantPredicateType.this.getter.apply(entity).filter(this.variant::equals).isPresent();
            }
        }
    }

    public static class EntityHolderVariantPredicateType<V> {
        final MapCodec<Instance> codec;
        final Function<Entity, Optional<Holder<V>>> getter;

        public static <V> EntityHolderVariantPredicateType<V> create(ResourceKey<? extends Registry<V>> registryRef, Function<Entity, Optional<Holder<V>>> variantGetter) {
            return new EntityHolderVariantPredicateType<V>(registryRef, variantGetter);
        }

        public EntityHolderVariantPredicateType(ResourceKey<? extends Registry<V>> registryRef, Function<Entity, Optional<Holder<V>>> variantGetter) {
            this.getter = variantGetter;
            this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(registryRef).fieldOf("variant").forGetter(type -> type.variants)).apply((Applicative)instance, entries -> new Instance(entries)));
        }

        public EntitySubPredicate createPredicate(HolderSet<V> variants) {
            return new Instance(variants);
        }

        class Instance
        implements EntitySubPredicate {
            final HolderSet<V> variants;

            Instance(HolderSet<V> variants) {
                this.variants = variants;
            }

            @Override
            public MapCodec<Instance> codec() {
                return EntityHolderVariantPredicateType.this.codec;
            }

            @Override
            @Override
            public boolean matches(Entity entity, ServerLevel world, @Nullable Vec3 pos) {
                return EntityHolderVariantPredicateType.this.getter.apply(entity).filter(this.variants::contains).isPresent();
            }
        }
    }
}

