/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

public interface MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.swapped"));

    public Optional<T> min();

    public Optional<T> max();

    default public boolean isAny() {
        return this.min().isEmpty() && this.max().isEmpty();
    }

    default public Optional<T> unwrapPoint() {
        Optional<T> optional2;
        Optional<T> optional = this.min();
        return optional.equals(optional2 = this.max()) ? optional : Optional.empty();
    }

    public static <T extends Number, R extends MinMaxBounds<T>> Codec<R> createCodec(Codec<T> valueCodec, BoundsFactory<T, R> rangeFactory) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)valueCodec.optionalFieldOf("min").forGetter(MinMaxBounds::min), (App)valueCodec.optionalFieldOf("max").forGetter(MinMaxBounds::max)).apply((Applicative)instance, rangeFactory::create));
        return Codec.either((Codec)codec, valueCodec).xmap(either -> either.map(range -> range, value -> rangeFactory.create(Optional.of(value), Optional.of(value))), range -> {
            Optional optional = range.unwrapPoint();
            return optional.isPresent() ? Either.right((Number)optional.get()) : Either.left(range);
        });
    }

    public static <T extends Number, R extends MinMaxBounds<T>> R fromReader(StringReader commandReader, BoundsFromReaderFactory<T, R> commandFactory, Function<String, T> converter, Supplier<DynamicCommandExceptionType> exceptionTypeSupplier, Function<T, T> mapper) throws CommandSyntaxException {
        if (!commandReader.canRead()) {
            throw ERROR_EMPTY.createWithContext((ImmutableStringReader)commandReader);
        }
        int i = commandReader.getCursor();
        try {
            Optional<T> optional3;
            Optional<T> optional = MinMaxBounds.readNumber(commandReader, converter, exceptionTypeSupplier).map(mapper);
            if (commandReader.canRead(2) && commandReader.peek() == '.' && commandReader.peek(1) == '.') {
                commandReader.skip();
                commandReader.skip();
                Optional<T> optional2 = MinMaxBounds.readNumber(commandReader, converter, exceptionTypeSupplier).map(mapper);
                if (optional.isEmpty() && optional2.isEmpty()) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)commandReader);
                }
            } else {
                optional3 = optional;
            }
            if (optional.isEmpty() && optional3.isEmpty()) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)commandReader);
            }
            return commandFactory.create(commandReader, optional, optional3);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            commandReader.setCursor(i);
            throw new CommandSyntaxException(commandSyntaxException.getType(), commandSyntaxException.getRawMessage(), commandSyntaxException.getInput(), i);
        }
    }

    private static <T extends Number> Optional<T> readNumber(StringReader reader, Function<String, T> converter, Supplier<DynamicCommandExceptionType> exceptionTypeSupplier) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && MinMaxBounds.isAllowedInputChat(reader)) {
            reader.skip();
        }
        String string = reader.getString().substring(i, reader.getCursor());
        if (string.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of((Number)converter.apply(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw exceptionTypeSupplier.get().createWithContext((ImmutableStringReader)reader, (Object)string);
        }
    }

    private static boolean isAllowedInputChat(StringReader reader) {
        char c = reader.peek();
        if (c >= '0' && c <= '9' || c == '-') {
            return true;
        }
        if (c == '.') {
            return !reader.canRead(2) || reader.peek(1) != '.';
        }
        return false;
    }

    @FunctionalInterface
    public static interface BoundsFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    public static interface BoundsFromReaderFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(StringReader var1, Optional<T> var2, Optional<T> var3) throws CommandSyntaxException;
    }

    public record Doubles(Optional<Double> min, Optional<Double> max, Optional<Double> minSq, Optional<Double> maxSq) implements MinMaxBounds<Double>
    {
        public static final Doubles ANY = new Doubles(Optional.empty(), Optional.empty());
        public static final Codec<Doubles> CODEC = MinMaxBounds.createCodec(Codec.DOUBLE, Doubles::new);

        private Doubles(Optional<Double> min, Optional<Double> max) {
            this(min, max, Doubles.squareOpt(min), Doubles.squareOpt(max));
        }

        private static Doubles create(StringReader reader, Optional<Double> min, Optional<Double> max) throws CommandSyntaxException {
            if (min.isPresent() && max.isPresent() && min.get() > max.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)reader);
            }
            return new Doubles(min, max);
        }

        private static Optional<Double> squareOpt(Optional<Double> value) {
            return value.map(d -> d * d);
        }

        public static Doubles exactly(double value) {
            return new Doubles(Optional.of(value), Optional.of(value));
        }

        public static Doubles between(double min, double max) {
            return new Doubles(Optional.of(min), Optional.of(max));
        }

        public static Doubles atLeast(double value) {
            return new Doubles(Optional.of(value), Optional.empty());
        }

        public static Doubles atMost(double value) {
            return new Doubles(Optional.empty(), Optional.of(value));
        }

        public boolean matches(double value) {
            if (this.min.isPresent() && this.min.get() > value) {
                return false;
            }
            return this.max.isEmpty() || !(this.max.get() < value);
        }

        public boolean matchesSqr(double value) {
            if (this.minSq.isPresent() && this.minSq.get() > value) {
                return false;
            }
            return this.maxSq.isEmpty() || !(this.maxSq.get() < value);
        }

        public static Doubles fromReader(StringReader reader) throws CommandSyntaxException {
            return Doubles.fromReader(reader, value -> value);
        }

        public static Doubles fromReader(StringReader reader, Function<Double, Double> mapper) throws CommandSyntaxException {
            return MinMaxBounds.fromReader(reader, Doubles::create, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), mapper);
        }
    }

    public record Ints(Optional<Integer> min, Optional<Integer> max, Optional<Long> minSq, Optional<Long> maxSq) implements MinMaxBounds<Integer>
    {
        public static final Ints ANY = new Ints(Optional.empty(), Optional.empty());
        public static final Codec<Ints> CODEC = MinMaxBounds.createCodec(Codec.INT, Ints::new);

        private Ints(Optional<Integer> min, Optional<Integer> max) {
            this(min, max, min.map(i -> i.longValue() * i.longValue()), Ints.squareOpt(max));
        }

        private static Ints create(StringReader reader, Optional<Integer> min, Optional<Integer> max) throws CommandSyntaxException {
            if (min.isPresent() && max.isPresent() && min.get() > max.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)reader);
            }
            return new Ints(min, max);
        }

        private static Optional<Long> squareOpt(Optional<Integer> value) {
            return value.map(i -> i.longValue() * i.longValue());
        }

        public static Ints exactly(int value) {
            return new Ints(Optional.of(value), Optional.of(value));
        }

        public static Ints between(int min, int max) {
            return new Ints(Optional.of(min), Optional.of(max));
        }

        public static Ints atLeast(int value) {
            return new Ints(Optional.of(value), Optional.empty());
        }

        public static Ints atMost(int value) {
            return new Ints(Optional.empty(), Optional.of(value));
        }

        public boolean matches(int value) {
            if (this.min.isPresent() && this.min.get() > value) {
                return false;
            }
            return this.max.isEmpty() || this.max.get() >= value;
        }

        public boolean matchesSqr(long value) {
            if (this.minSq.isPresent() && this.minSq.get() > value) {
                return false;
            }
            return this.maxSq.isEmpty() || this.maxSq.get() >= value;
        }

        public static Ints fromReader(StringReader reader) throws CommandSyntaxException {
            return Ints.fromReader(reader, value -> value);
        }

        public static Ints fromReader(StringReader reader, Function<Integer, Integer> converter) throws CommandSyntaxException {
            return MinMaxBounds.fromReader(reader, Ints::create, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), converter);
        }
    }
}

