/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.EntryAction;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.ContinuationTask;
import net.minecraft.commands.execution.tasks.ExecuteCommand;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.network.chat.Component;

public class BuildContexts<T extends ExecutionCommandSource<T>> {
    @VisibleForTesting
    public static final DynamicCommandExceptionType ERROR_FORK_LIMIT_REACHED = new DynamicCommandExceptionType(count -> Component.translatableEscape("command.forkLimit", count));
    private final String commandInput;
    private final ContextChain<T> command;

    public BuildContexts(String command, ContextChain<T> contextChain) {
        this.commandInput = command;
        this.command = contextChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(T baseSource, List<T> sources, ExecutionContext<T> context2, Frame frame2, ChainModifiers flags) {
        ContextChain contextChain = this.command;
        ChainModifiers chainModifiers = flags;
        List<Object> list = sources;
        if (contextChain.getStage() != ContextChain.Stage.EXECUTE) {
            context2.profiler().push(() -> "prepare " + this.commandInput);
            try {
                int i = context2.forkLimit();
                while (contextChain.getStage() != ContextChain.Stage.EXECUTE) {
                    RedirectModifier redirectModifier;
                    CommandContext commandContext = contextChain.getTopContext();
                    if (commandContext.isForked()) {
                        chainModifiers = chainModifiers.setForked();
                    }
                    if ((redirectModifier = commandContext.getRedirectModifier()) instanceof CustomModifierExecutor) {
                        CustomModifierExecutor customModifierExecutor = (CustomModifierExecutor)redirectModifier;
                        customModifierExecutor.apply(baseSource, list, contextChain, chainModifiers, ExecutionControl.create(context2, frame2));
                        return;
                    }
                    if (redirectModifier != null) {
                        context2.incrementCost();
                        boolean bl = chainModifiers.isForked();
                        ObjectArrayList list2 = new ObjectArrayList();
                        for (ExecutionCommandSource executionCommandSource : list) {
                            Collection collection;
                            block21: {
                                try {
                                    collection = ContextChain.runModifier((CommandContext)commandContext, (Object)executionCommandSource, (context, successful, returnValue) -> {}, (boolean)bl);
                                    if (list2.size() + collection.size() < i) break block21;
                                    baseSource.handleError(ERROR_FORK_LIMIT_REACHED.create((Object)i), bl, context2.tracer());
                                    return;
                                }
                                catch (CommandSyntaxException commandSyntaxException) {
                                    executionCommandSource.handleError(commandSyntaxException, bl, context2.tracer());
                                    if (bl) continue;
                                    context2.profiler().pop();
                                    return;
                                }
                            }
                            list2.addAll(collection);
                        }
                        list = list2;
                    }
                    contextChain = contextChain.nextStage();
                }
            }
            finally {
                context2.profiler().pop();
            }
        }
        if (list.isEmpty()) {
            if (chainModifiers.isReturn()) {
                context2.queueNext(new CommandQueueEntry(frame2, FallthroughTask.instance()));
            }
            return;
        }
        CommandContext commandContext2 = contextChain.getTopContext();
        Command command = commandContext2.getCommand();
        if (command instanceof CustomCommandExecutor) {
            CustomCommandExecutor customCommandExecutor = (CustomCommandExecutor)command;
            ExecutionControl executionControl = ExecutionControl.create(context2, frame2);
            for (ExecutionCommandSource executionCommandSource : list) {
                customCommandExecutor.run(executionCommandSource, contextChain, chainModifiers, executionControl);
            }
        } else {
            if (chainModifiers.isReturn()) {
                ExecutionCommandSource executionCommandSource3 = (ExecutionCommandSource)list.get(0);
                executionCommandSource3 = executionCommandSource3.withCallback(CommandResultCallback.chain(executionCommandSource3.callback(), frame2.returnValueConsumer()));
                list = List.of(executionCommandSource3);
            }
            ExecuteCommand executeCommand = new ExecuteCommand(this.commandInput, chainModifiers, commandContext2);
            ContinuationTask.schedule(context2, frame2, list, (frame, source) -> new CommandQueueEntry<ExecutionCommandSource>(frame, executeCommand.bind(source)));
        }
    }

    protected void traceCommandStart(ExecutionContext<T> context, Frame frame) {
        TraceCallbacks traceCallbacks = context.tracer();
        if (traceCallbacks != null) {
            traceCallbacks.onCommand(frame.depth(), this.commandInput);
        }
    }

    @Override
    public String toString() {
        return this.commandInput;
    }

    public static class TopLevel<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements EntryAction<T> {
        private final T source;

        public TopLevel(String command, ContextChain<T> contextChain, T source) {
            super(command, contextChain);
            this.source = source;
        }

        @Override
        @Override
        public void execute(ExecutionContext<T> context, Frame frame) {
            this.traceCommandStart(context, frame);
            this.execute(this.source, List.of(this.source), context, frame, ChainModifiers.DEFAULT);
        }
    }

    public static class Continuation<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements EntryAction<T> {
        private final ChainModifiers modifiers;
        private final T originalSource;
        private final List<T> sources;

        public Continuation(String command, ContextChain<T> contextChain, ChainModifiers flags, T baseSource, List<T> sources) {
            super(command, contextChain);
            this.originalSource = baseSource;
            this.sources = sources;
            this.modifiers = flags;
        }

        @Override
        @Override
        public void execute(ExecutionContext<T> context, Frame frame) {
            this.execute(this.originalSource, this.sources, context, frame, this.modifiers);
        }
    }

    public static class Unbound<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements UnboundEntryAction<T> {
        public Unbound(String command, ContextChain<T> contextChain) {
            super(command, contextChain);
        }

        @Override
        @Override
        public void execute(T executionCommandSource, ExecutionContext<T> executionContext, Frame frame) {
            this.traceCommandStart(executionContext, frame);
            this.execute(executionCommandSource, List.of(executionCommandSource), executionContext, frame, ChainModifiers.DEFAULT);
        }

        @Override
        public /* synthetic */ void execute(Object source, ExecutionContext context, Frame frame) {
            this.execute((ExecutionCommandSource)source, context, frame);
        }
    }
}

