/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class FloatArgumentInfo
implements ArgumentTypeInfo<FloatArgumentType, Template> {
    @Override
    @Override
    public void serializeToNetwork(Template properties, FriendlyByteBuf buf) {
        boolean bl = properties.min != -3.4028235E38f;
        boolean bl2 = properties.max != Float.MAX_VALUE;
        buf.writeByte(ArgumentUtils.createNumberFlags(bl, bl2));
        if (bl) {
            buf.writeFloat(properties.min);
        }
        if (bl2) {
            buf.writeFloat(properties.max);
        }
    }

    @Override
    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        byte b = friendlyByteBuf.readByte();
        float f = ArgumentUtils.numberHasMin(b) ? friendlyByteBuf.readFloat() : -3.4028235E38f;
        float g = ArgumentUtils.numberHasMax(b) ? friendlyByteBuf.readFloat() : Float.MAX_VALUE;
        return new Template(f, g);
    }

    @Override
    @Override
    public void serializeToJson(Template properties, JsonObject json) {
        if (properties.min != -3.4028235E38f) {
            json.addProperty("min", (Number)Float.valueOf(properties.min));
        }
        if (properties.max != Float.MAX_VALUE) {
            json.addProperty("max", (Number)Float.valueOf(properties.max));
        }
    }

    @Override
    @Override
    public Template unpack(FloatArgumentType argumentType) {
        return new Template(argumentType.getMinimum(), argumentType.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf buf) {
        return this.deserializeFromNetwork(buf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<FloatArgumentType> {
        final float min;
        final float max;

        Template(float min, float max) {
            this.min = min;
            this.max = max;
        }

        @Override
        @Override
        public FloatArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return FloatArgumentType.floatArg((float)this.min, (float)this.max);
        }

        @Override
        @Override
        public ArgumentTypeInfo<FloatArgumentType, ?> type() {
            return FloatArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandRegistryAccess) {
            return this.instantiate(commandRegistryAccess);
        }
    }
}

