/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class IntegerArgumentInfo
implements ArgumentTypeInfo<IntegerArgumentType, Template> {
    @Override
    @Override
    public void serializeToNetwork(Template properties, FriendlyByteBuf buf) {
        boolean bl = properties.min != Integer.MIN_VALUE;
        boolean bl2 = properties.max != Integer.MAX_VALUE;
        buf.writeByte(ArgumentUtils.createNumberFlags(bl, bl2));
        if (bl) {
            buf.writeInt(properties.min);
        }
        if (bl2) {
            buf.writeInt(properties.max);
        }
    }

    @Override
    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        byte b = friendlyByteBuf.readByte();
        int i = ArgumentUtils.numberHasMin(b) ? friendlyByteBuf.readInt() : Integer.MIN_VALUE;
        int j = ArgumentUtils.numberHasMax(b) ? friendlyByteBuf.readInt() : Integer.MAX_VALUE;
        return new Template(i, j);
    }

    @Override
    @Override
    public void serializeToJson(Template properties, JsonObject json) {
        if (properties.min != Integer.MIN_VALUE) {
            json.addProperty("min", (Number)properties.min);
        }
        if (properties.max != Integer.MAX_VALUE) {
            json.addProperty("max", (Number)properties.max);
        }
    }

    @Override
    @Override
    public Template unpack(IntegerArgumentType argumentType) {
        return new Template(argumentType.getMinimum(), argumentType.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf buf) {
        return this.deserializeFromNetwork(buf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<IntegerArgumentType> {
        final int min;
        final int max;

        Template(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        @Override
        public IntegerArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return IntegerArgumentType.integer((int)this.min, (int)this.max);
        }

        @Override
        @Override
        public ArgumentTypeInfo<IntegerArgumentType, ?> type() {
            return IntegerArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandRegistryAccess) {
            return this.instantiate(commandRegistryAccess);
        }
    }
}

