/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class LongArgumentInfo
implements ArgumentTypeInfo<LongArgumentType, Template> {
    @Override
    @Override
    public void serializeToNetwork(Template properties, FriendlyByteBuf buf) {
        boolean bl = properties.min != Long.MIN_VALUE;
        boolean bl2 = properties.max != Long.MAX_VALUE;
        buf.writeByte(ArgumentUtils.createNumberFlags(bl, bl2));
        if (bl) {
            buf.writeLong(properties.min);
        }
        if (bl2) {
            buf.writeLong(properties.max);
        }
    }

    @Override
    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        byte b = friendlyByteBuf.readByte();
        long l = ArgumentUtils.numberHasMin(b) ? friendlyByteBuf.readLong() : Long.MIN_VALUE;
        long m = ArgumentUtils.numberHasMax(b) ? friendlyByteBuf.readLong() : Long.MAX_VALUE;
        return new Template(l, m);
    }

    @Override
    @Override
    public void serializeToJson(Template properties, JsonObject json) {
        if (properties.min != Long.MIN_VALUE) {
            json.addProperty("min", (Number)properties.min);
        }
        if (properties.max != Long.MAX_VALUE) {
            json.addProperty("max", (Number)properties.max);
        }
    }

    @Override
    @Override
    public Template unpack(LongArgumentType argumentType) {
        return new Template(argumentType.getMinimum(), argumentType.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf buf) {
        return this.deserializeFromNetwork(buf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<LongArgumentType> {
        final long min;
        final long max;

        Template(long min, long max) {
            this.min = min;
            this.max = max;
        }

        @Override
        @Override
        public LongArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return LongArgumentType.longArg((long)this.min, (long)this.max);
        }

        @Override
        @Override
        public ArgumentTypeInfo<LongArgumentType, ?> type() {
            return LongArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandRegistryAccess) {
            return this.instantiate(commandRegistryAccess);
        }
    }
}

