/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public interface HolderGetter<T> {
    public Optional<Holder.Reference<T>> get(ResourceKey<T> var1);

    default public Holder.Reference<T> getOrThrow(ResourceKey<T> key) {
        return this.get(key).orElseThrow(() -> new IllegalStateException("Missing element " + String.valueOf(key)));
    }

    public Optional<HolderSet.Named<T>> get(TagKey<T> var1);

    default public HolderSet.Named<T> getOrThrow(TagKey<T> tag) {
        return this.get(tag).orElseThrow(() -> new IllegalStateException("Missing tag " + String.valueOf(tag)));
    }

    public static interface Provider {
        public <T> Optional<HolderGetter<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);

        default public <T> HolderGetter<T> lookupOrThrow(ResourceKey<? extends Registry<? extends T>> registryRef) {
            return this.lookup(registryRef).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(registryRef.location()) + " not found"));
        }

        default public <T> Optional<Holder.Reference<T>> get(ResourceKey<? extends Registry<? extends T>> registryRef, ResourceKey<T> key) {
            return this.lookup(registryRef).flatMap(registryEntryLookup -> registryEntryLookup.get(key));
        }
    }
}

