/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.Reference<T>> listElements();

    default public Stream<ResourceKey<T>> listElementIds() {
        return this.listElements().map(Holder.Reference::key);
    }

    public Stream<HolderSet.Named<T>> listTags();

    default public Stream<TagKey<T>> listTagIds() {
        return this.listTags().map(HolderSet.Named::key);
    }

    public static interface Provider {
        public Stream<ResourceKey<? extends Registry<?>>> listRegistries();

        public <T> Optional<RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);

        default public <T> RegistryLookup<T> lookupOrThrow(ResourceKey<? extends Registry<? extends T>> registryRef) {
            return this.lookup(registryRef).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(registryRef.location()) + " not found"));
        }

        default public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> delegate) {
            return RegistryOps.create(delegate, this);
        }

        default public HolderGetter.Provider asGetterLookup() {
            return new HolderGetter.Provider(){

                @Override
                @Override
                public <T> Optional<HolderGetter<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                    return this.lookup(registryRef).map(lookup -> lookup);
                }
            };
        }

        public static Provider create(Stream<RegistryLookup<?>> wrappers) {
            final Map<ResourceKey, RegistryLookup> map = wrappers.collect(Collectors.toUnmodifiableMap(RegistryLookup::key, wrapper -> wrapper));
            return new Provider(){

                @Override
                @Override
                public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                    return map.keySet().stream();
                }

                @Override
                @Override
                public <T> Optional<RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                    return Optional.ofNullable((RegistryLookup)map.get(registryRef));
                }
            };
        }
    }

    public static interface RegistryLookup<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public ResourceKey<? extends Registry<? extends T>> key();

        public Lifecycle registryLifecycle();

        default public RegistryLookup<T> filterFeatures(FeatureFlagSet enabledFeatures) {
            if (FeatureElement.FILTERED_REGISTRIES.contains(this.key())) {
                return this.filterElements(feature -> ((FeatureElement)feature).isEnabled(enabledFeatures));
            }
            return this;
        }

        default public RegistryLookup<T> filterElements(final Predicate<T> predicate) {
            return new Delegate<T>(){

                @Override
                @Override
                public RegistryLookup<T> parent() {
                    return this;
                }

                @Override
                @Override
                public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
                    return this.parent().get(key).filter(entry -> predicate.test(entry.value()));
                }

                @Override
                @Override
                public Stream<Holder.Reference<T>> listElements() {
                    return this.parent().listElements().filter(entry -> predicate.test(entry.value()));
                }
            };
        }

        public static interface Delegate<T>
        extends RegistryLookup<T> {
            public RegistryLookup<T> parent();

            @Override
            @Override
            default public ResourceKey<? extends Registry<? extends T>> key() {
                return this.parent().key();
            }

            @Override
            @Override
            default public Lifecycle registryLifecycle() {
                return this.parent().registryLifecycle();
            }

            @Override
            @Override
            default public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
                return this.parent().get(key);
            }

            @Override
            @Override
            default public Stream<Holder.Reference<T>> listElements() {
                return this.parent().listElements();
            }

            @Override
            @Override
            default public Optional<HolderSet.Named<T>> get(TagKey<T> tag) {
                return this.parent().get(tag);
            }

            @Override
            @Override
            default public Stream<HolderSet.Named<T>> listTags() {
                return this.parent().listTags();
            }
        }
    }
}

