/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.placement.VillagePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class TaigaVillagePools {
    public static final ResourceKey<StructureTemplatePool> START = Pools.createKey("village/taiga/town_centers");
    private static final ResourceKey<StructureTemplatePool> TERMINATORS_KEY = Pools.createKey("village/taiga/terminators");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> poolRegisterable) {
        HolderGetter<PlacedFeature> holderGetter = poolRegisterable.lookup(Registries.PLACED_FEATURE);
        Holder.Reference<PlacedFeature> holder = holderGetter.getOrThrow(VillagePlacements.SPRUCE_VILLAGE);
        Holder.Reference<PlacedFeature> holder2 = holderGetter.getOrThrow(VillagePlacements.PINE_VILLAGE);
        Holder.Reference<PlacedFeature> holder3 = holderGetter.getOrThrow(VillagePlacements.PILE_PUMPKIN_VILLAGE);
        Holder.Reference<PlacedFeature> holder4 = holderGetter.getOrThrow(VillagePlacements.PATCH_TAIGA_GRASS_VILLAGE);
        Holder.Reference<PlacedFeature> holder5 = holderGetter.getOrThrow(VillagePlacements.PATCH_BERRY_BUSH_VILLAGE);
        HolderGetter<StructureProcessorList> holderGetter2 = poolRegisterable.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference<StructureProcessorList> holder6 = holderGetter2.getOrThrow(ProcessorLists.MOSSIFY_10_PERCENT);
        Holder.Reference<StructureProcessorList> holder7 = holderGetter2.getOrThrow(ProcessorLists.ZOMBIE_TAIGA);
        Holder.Reference<StructureProcessorList> holder8 = holderGetter2.getOrThrow(ProcessorLists.STREET_SNOWY_OR_TAIGA);
        Holder.Reference<StructureProcessorList> holder9 = holderGetter2.getOrThrow(ProcessorLists.FARM_TAIGA);
        HolderGetter<StructureTemplatePool> holderGetter3 = poolRegisterable.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> holder10 = holderGetter3.getOrThrow(Pools.EMPTY);
        Holder.Reference<StructureTemplatePool> holder11 = holderGetter3.getOrThrow(TERMINATORS_KEY);
        poolRegisterable.register(START, new StructureTemplatePool(holder10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/town_centers/taiga_meeting_point_1", holder6), (Object)49), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/town_centers/taiga_meeting_point_2", holder6), (Object)49), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/town_centers/taiga_meeting_point_1", holder7), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/town_centers/taiga_meeting_point_2", holder7), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "village/taiga/streets", new StructureTemplatePool(holder11, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/corner_01", holder8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/corner_02", holder8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/corner_03", holder8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/straight_01", holder8), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/straight_02", holder8), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/straight_03", holder8), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/straight_04", holder8), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/straight_05", holder8), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/straight_06", holder8), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/crossroad_01", holder8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/crossroad_02", holder8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/streets/crossroad_03", holder8), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/taiga/streets/crossroad_04", holder8), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/streets/crossroad_05", holder8), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/streets/crossroad_06", holder8), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/streets/turn_01", holder8), (Object)3)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(poolRegisterable, "village/taiga/zombie/streets", new StructureTemplatePool(holder11, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/corner_01", holder8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/corner_02", holder8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/corner_03", holder8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/straight_01", holder8), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/straight_02", holder8), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/straight_03", holder8), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/straight_04", holder8), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/straight_05", holder8), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/straight_06", holder8), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/crossroad_01", holder8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/crossroad_02", holder8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/crossroad_03", holder8), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/crossroad_04", holder8), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/crossroad_05", holder8), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/crossroad_06", holder8), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/streets/turn_01", holder8), (Object)3)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(poolRegisterable, "village/taiga/houses", new StructureTemplatePool(holder11, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_small_house_1", holder6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_small_house_2", holder6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_small_house_3", holder6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_small_house_4", holder6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_small_house_5", holder6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_medium_house_1", holder6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_medium_house_2", holder6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_medium_house_3", holder6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_medium_house_4", holder6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_butcher_shop_1", holder6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_tool_smith_1", holder6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_fletcher_house_1", holder6), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_shepherds_house_1", holder6), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_armorer_house_1", holder6), (Object)1), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_armorer_2", holder6), (Object)1), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_fisher_cottage_1", holder6), (Object)3), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_tannery_1", holder6), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_cartographer_house_1", holder6), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_library_1", holder6), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_masons_house_1", holder6), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_weaponsmith_1", holder6), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_weaponsmith_2", holder6), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_temple_1", holder6), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_large_farm_1", holder9), (Object)6), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_large_farm_2", holder9), (Object)6), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_small_farm_1", holder6), (Object)1), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_animal_pen_1", holder6), (Object)2), Pair.of(StructurePoolElement.empty(), (Object)6)}), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "village/taiga/zombie/houses", new StructureTemplatePool(holder11, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_small_house_1", holder7), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_small_house_2", holder7), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_small_house_3", holder7), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_small_house_4", holder7), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_small_house_5", holder7), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_medium_house_1", holder7), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_medium_house_2", holder7), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_medium_house_3", holder7), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_medium_house_4", holder7), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_butcher_shop_1", holder7), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_tool_smith_1", holder7), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_fletcher_house_1", holder7), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_shepherds_house_1", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_armorer_house_1", holder7), (Object)1), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_fisher_cottage_1", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_tannery_1", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_cartographer_house_1", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_library_1", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_masons_house_1", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_weaponsmith_1", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_weaponsmith_2", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_temple_1", holder7), (Object)2), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_large_farm_1", holder7), (Object)6), Pair.of(StructurePoolElement.legacy("village/taiga/zombie/houses/taiga_large_farm_2", holder7), (Object)6), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_small_farm_1", holder7), (Object)1), Pair.of(StructurePoolElement.legacy("village/taiga/houses/taiga_animal_pen_1", holder7), (Object)2), Pair.of(StructurePoolElement.empty(), (Object)6)}), StructureTemplatePool.Projection.RIGID));
        poolRegisterable.register(TERMINATORS_KEY, new StructureTemplatePool(holder10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_01", holder8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_02", holder8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_03", holder8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_04", holder8), (Object)1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(poolRegisterable, "village/taiga/decor", new StructureTemplatePool(holder10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_lamp_post_1"), (Object)10), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_1"), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_2"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_3"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_4"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_5"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_6"), (Object)1), (Object)Pair.of(StructurePoolElement.feature(holder), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder2), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder3), (Object)2), (Object)Pair.of(StructurePoolElement.feature(holder4), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder5), (Object)1), (Object[])new Pair[]{Pair.of(StructurePoolElement.empty(), (Object)4)}), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "village/taiga/zombie/decor", new StructureTemplatePool(holder10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_1"), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_2"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_3"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/taiga_decoration_4"), (Object)1), (Object)Pair.of(StructurePoolElement.feature(holder), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder2), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder3), (Object)2), (Object)Pair.of(StructurePoolElement.feature(holder4), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder5), (Object)1), (Object)Pair.of(StructurePoolElement.empty(), (Object)4)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "village/taiga/villagers", new StructureTemplatePool(holder10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/villagers/baby"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "village/taiga/zombie/villagers", new StructureTemplatePool(holder10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/taiga/zombie/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
    }
}

