/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;
import org.spigotmc.LimitStream;

public class NbtIo {
    private static final OpenOption[] SYNC_OUTPUT_OPTIONS = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static CompoundTag readCompressed(Path path, NbtAccounter tagSizeTracker) throws IOException {
        CompoundTag nbttagcompound;
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream fastbufferedinputstream = new FastBufferedInputStream(inputstream);){
            nbttagcompound = NbtIo.readCompressed(fastbufferedinputstream, tagSizeTracker);
        }
        return nbttagcompound;
    }

    private static DataInputStream createDecompressorStream(InputStream stream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(stream)));
    }

    private static DataOutputStream createCompressorStream(OutputStream stream) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream)));
    }

    public static CompoundTag readCompressed(InputStream stream, NbtAccounter tagSizeTracker) throws IOException {
        CompoundTag nbttagcompound;
        try (DataInputStream datainputstream = NbtIo.createDecompressorStream(stream);){
            nbttagcompound = NbtIo.read(datainputstream, tagSizeTracker);
        }
        return nbttagcompound;
    }

    public static void parseCompressed(Path path, StreamTagVisitor scanner, NbtAccounter tracker) throws IOException {
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream fastbufferedinputstream = new FastBufferedInputStream(inputstream);){
            NbtIo.parseCompressed(fastbufferedinputstream, scanner, tracker);
        }
    }

    public static void parseCompressed(InputStream stream, StreamTagVisitor scanner, NbtAccounter tracker) throws IOException {
        try (DataInputStream datainputstream = NbtIo.createDecompressorStream(stream);){
            NbtIo.parse(datainputstream, scanner, tracker);
        }
    }

    public static void writeCompressed(CompoundTag nbt, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(outputstream);){
            NbtIo.writeCompressed(nbt, bufferedoutputstream);
        }
    }

    public static void writeCompressed(CompoundTag nbt, OutputStream stream) throws IOException {
        try (DataOutputStream dataoutputstream = NbtIo.createCompressorStream(stream);){
            NbtIo.write(nbt, dataoutputstream);
        }
    }

    public static void write(CompoundTag nbt, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(outputstream);
             DataOutputStream dataoutputstream = new DataOutputStream(bufferedoutputstream);){
            NbtIo.write(nbt, dataoutputstream);
        }
    }

    @Nullable
    public static CompoundTag read(Path path) throws IOException {
        CompoundTag nbttagcompound;
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             DataInputStream datainputstream = new DataInputStream(inputstream);){
            nbttagcompound = NbtIo.read(datainputstream, NbtAccounter.unlimitedHeap());
        }
        return nbttagcompound;
    }

    public static CompoundTag read(DataInput input) throws IOException {
        return NbtIo.read(input, NbtAccounter.unlimitedHeap());
    }

    public static CompoundTag read(DataInput input, NbtAccounter tracker) throws IOException {
        Tag nbtbase;
        if (input instanceof ByteBufInputStream) {
            input = new DataInputStream(new LimitStream((InputStream)((Object)input), tracker));
        }
        if ((nbtbase = NbtIo.readUnnamedTag(input, tracker)) instanceof CompoundTag) {
            return (CompoundTag)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(CompoundTag nbt, DataOutput output) throws IOException {
        NbtIo.writeUnnamedTagWithFallback(nbt, output);
    }

    public static void parse(DataInput input, StreamTagVisitor scanner, NbtAccounter tracker) throws IOException {
        TagType<?> nbttagtype = TagTypes.getType(input.readByte());
        if (nbttagtype == EndTag.TYPE) {
            if (scanner.visitRootEntry(EndTag.TYPE) == StreamTagVisitor.ValueResult.CONTINUE) {
                scanner.visitEnd();
            }
        } else {
            switch (scanner.visitRootEntry(nbttagtype)) {
                default: {
                    break;
                }
                case BREAK: {
                    StringTag.skipString(input);
                    nbttagtype.skip(input, tracker);
                    break;
                }
                case CONTINUE: {
                    StringTag.skipString(input);
                    nbttagtype.parse(input, scanner, tracker);
                }
            }
        }
    }

    public static Tag readAnyTag(DataInput input, NbtAccounter tracker) throws IOException {
        byte b0 = input.readByte();
        return b0 == 0 ? EndTag.INSTANCE : NbtIo.readTagSafe(input, tracker, b0);
    }

    public static void writeAnyTag(Tag nbt, DataOutput output) throws IOException {
        output.writeByte(nbt.getId());
        if (nbt.getId() != 0) {
            nbt.write(output);
        }
    }

    public static void writeUnnamedTag(Tag nbt, DataOutput output) throws IOException {
        output.writeByte(nbt.getId());
        if (nbt.getId() != 0) {
            output.writeUTF("");
            nbt.write(output);
        }
    }

    public static void writeUnnamedTagWithFallback(Tag nbt, DataOutput output) throws IOException {
        NbtIo.writeUnnamedTag(nbt, new StringFallbackDataOutput(output));
    }

    private static Tag readUnnamedTag(DataInput input, NbtAccounter tracker) throws IOException {
        byte b0 = input.readByte();
        if (b0 == 0) {
            return EndTag.INSTANCE;
        }
        StringTag.skipString(input);
        return NbtIo.readTagSafe(input, tracker, b0);
    }

    private static Tag readTagSafe(DataInput input, NbtAccounter tracker, byte typeId) {
        try {
            return TagTypes.getType(typeId).load(input, tracker);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.forThrowable(ioexception, "Loading NBT data");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("NBT Tag");
            crashreportsystemdetails.setDetail("Tag type", typeId);
            throw new ReportedNbtException(crashreport);
        }
    }

    public static class StringFallbackDataOutput
    extends DelegateDataOutput {
        public StringFallbackDataOutput(DataOutput delegate) {
            super(delegate);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            try {
                super.writeUTF(s);
            }
            catch (UTFDataFormatException utfdataformatexception) {
                Util.logAndPauseIfInIde("Failed to write NBT String", utfdataformatexception);
                super.writeUTF("");
            }
        }
    }
}

