/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;

public class ShortTag
extends NumericTag {
    private static final int SELF_SIZE_IN_BYTES = 10;
    public static final TagType<ShortTag> TYPE = new TagType.StaticSize<ShortTag>(){

        @Override
        @Override
        public ShortTag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return ShortTag.valueOf(1.readAccounted(dataInput, nbtAccounter));
        }

        @Override
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor, NbtAccounter tracker) throws IOException {
            return visitor.visit(1.readAccounted(input, tracker));
        }

        private static short readAccounted(DataInput input, NbtAccounter tracker) throws IOException {
            tracker.accountBytes(10L);
            return input.readShort();
        }

        @Override
        @Override
        public int size() {
            return 2;
        }

        @Override
        @Override
        public String getName() {
            return "SHORT";
        }

        @Override
        @Override
        public String getPrettyName() {
            return "TAG_Short";
        }

        @Override
        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ Tag load(DataInput input, NbtAccounter tracker) throws IOException {
            return this.load(input, tracker);
        }
    };
    private final short data;

    ShortTag(short value) {
        this.data = value;
    }

    public static ShortTag valueOf(short value) {
        if (value >= -128 && value <= 1024) {
            return Cache.cache[value - -128];
        }
        return new ShortTag(value);
    }

    @Override
    @Override
    public void write(DataOutput output) throws IOException {
        output.writeShort(this.data);
    }

    @Override
    @Override
    public int sizeInBytes() {
        return 10;
    }

    @Override
    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public TagType<ShortTag> getType() {
        return TYPE;
    }

    @Override
    @Override
    public ShortTag copy() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ShortTag && this.data == ((ShortTag)object).data;
    }

    @Override
    public int hashCode() {
        return this.data;
    }

    @Override
    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitShort(this);
    }

    @Override
    @Override
    public long getAsLong() {
        return this.data;
    }

    @Override
    @Override
    public int getAsInt() {
        return this.data;
    }

    @Override
    @Override
    public short getAsShort() {
        return this.data;
    }

    @Override
    @Override
    public byte getAsByte() {
        return (byte)(this.data & 0xFF);
    }

    @Override
    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    @Override
    public float getAsFloat() {
        return this.data;
    }

    @Override
    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        return visitor.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }

    static class Cache {
        private static final int HIGH = 1024;
        private static final int LOW = -128;
        static final ShortTag[] cache = new ShortTag[1153];

        private Cache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                Cache.cache[i] = new ShortTag((short)(-128 + i));
            }
        }
    }
}

