/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.visitors.CollectToTag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.FieldTree;

public class SkipFields
extends CollectToTag {
    private final Deque<FieldTree> stack = new ArrayDeque<FieldTree>();

    public SkipFields(FieldSelector ... excludedQueries) {
        FieldTree fieldTree = FieldTree.createRoot();
        for (FieldSelector fieldSelector : excludedQueries) {
            fieldTree.addEntry(fieldSelector);
        }
        this.stack.push(fieldTree);
    }

    @Override
    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> type, String key) {
        FieldTree fieldTree2;
        FieldTree fieldTree = this.stack.element();
        if (fieldTree.isSelected(type, key)) {
            return StreamTagVisitor.EntryResult.SKIP;
        }
        if (type == CompoundTag.TYPE && (fieldTree2 = fieldTree.fieldsToRecurse().get(key)) != null) {
            this.stack.push(fieldTree2);
        }
        return super.visitEntry(type, key);
    }

    @Override
    @Override
    public StreamTagVisitor.ValueResult visitContainerEnd() {
        if (this.depth() == this.stack.element().depth()) {
            this.stack.pop();
        }
        return super.visitContainerEnd();
    }
}

