/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf> {
    final ConnectionProtocol protocol;
    final PacketFlow flow;
    private final List<CodecEntry<T, ?, B>> codecs = new ArrayList();
    @Nullable
    private BundlerInfo bundlerInfo;

    public ProtocolInfoBuilder(ConnectionProtocol type, PacketFlow side) {
        this.protocol = type;
        this.flow = side;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B> addPacket(PacketType<P> id, StreamCodec<? super B, P> codec) {
        this.codecs.add(new CodecEntry(id, codec));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B> withBundlePacket(PacketType<P> id, Function<Iterable<Packet<? super T>>, P> bundler, D splitter) {
        StreamCodec streamCodec = StreamCodec.unit(splitter);
        PacketType<BundleDelimiterPacket<? super T>> packetType = splitter.type();
        this.codecs.add(new CodecEntry(packetType, streamCodec));
        this.bundlerInfo = BundlerInfo.createForPacket(id, bundler, splitter);
        return this;
    }

    StreamCodec<ByteBuf, Packet<? super T>> buildPacketCodec(Function<ByteBuf, B> bufUpgrader, List<CodecEntry<T, ?, B>> packetTypes) {
        ProtocolCodecBuilder protocolCodecBuilder = new ProtocolCodecBuilder(this.flow);
        for (CodecEntry codecEntry : packetTypes) {
            codecEntry.addToBuilder(protocolCodecBuilder, bufUpgrader);
        }
        return protocolCodecBuilder.build();
    }

    public ProtocolInfo<T> build(Function<ByteBuf, B> bufUpgrader) {
        return new Implementation(this.protocol, this.flow, this.buildPacketCodec(bufUpgrader, this.codecs), this.bundlerInfo);
    }

    public ProtocolInfo.Unbound<T, B> buildUnbound() {
        final List<CodecEntry<T, ?, B>> list = List.copyOf(this.codecs);
        final BundlerInfo bundlerInfo = this.bundlerInfo;
        return new ProtocolInfo.Unbound<T, B>(){

            @Override
            @Override
            public ProtocolInfo<T> bind(Function<ByteBuf, B> registryBinder) {
                return new Implementation(ProtocolInfoBuilder.this.protocol, ProtocolInfoBuilder.this.flow, ProtocolInfoBuilder.this.buildPacketCodec(registryBinder, list), bundlerInfo);
            }

            @Override
            @Override
            public ConnectionProtocol id() {
                return ProtocolInfoBuilder.this.protocol;
            }

            @Override
            @Override
            public PacketFlow flow() {
                return ProtocolInfoBuilder.this.flow;
            }

            @Override
            @Override
            public void listPackets(ProtocolInfo.Unbound.PacketVisitor callback) {
                for (int i = 0; i < list.size(); ++i) {
                    CodecEntry codecEntry = (CodecEntry)list.get(i);
                    callback.accept(codecEntry.type, i);
                }
            }
        };
    }

    private static <L extends PacketListener, B extends ByteBuf> ProtocolInfo.Unbound<L, B> protocol(ConnectionProtocol type, PacketFlow side, Consumer<ProtocolInfoBuilder<L, B>> registrar) {
        ProtocolInfoBuilder protocolInfoBuilder = new ProtocolInfoBuilder(type, side);
        registrar.accept(protocolInfoBuilder);
        return protocolInfoBuilder.buildUnbound();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> ProtocolInfo.Unbound<T, B> serverboundProtocol(ConnectionProtocol type, Consumer<ProtocolInfoBuilder<T, B>> registrar) {
        return ProtocolInfoBuilder.protocol(type, PacketFlow.SERVERBOUND, registrar);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> ProtocolInfo.Unbound<T, B> clientboundProtocol(ConnectionProtocol type, Consumer<ProtocolInfoBuilder<T, B>> registrar) {
        return ProtocolInfoBuilder.protocol(type, PacketFlow.CLIENTBOUND, registrar);
    }

    record CodecEntry<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf>(PacketType<P> type, StreamCodec<? super B, P> serializer) {
        public void addToBuilder(ProtocolCodecBuilder<ByteBuf, T> builder, Function<ByteBuf, B> bufUpgrader) {
            StreamCodec<ByteBuf, P> streamCodec = this.serializer.mapStream(bufUpgrader);
            builder.add(this.type, streamCodec);
        }
    }

    record Implementation<L extends PacketListener>(ConnectionProtocol id, PacketFlow flow, StreamCodec<ByteBuf, Packet<? super L>> codec, @Nullable BundlerInfo bundlerInfo) implements ProtocolInfo<L>
    {
    }
}

