/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record GoalDebugPayload(int entityId, BlockPos pos, List<DebugGoal> goals) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, GoalDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(GoalDebugPayload::write, GoalDebugPayload::new);
    public static final CustomPacketPayload.Type<GoalDebugPayload> TYPE = CustomPacketPayload.createType("debug/goal_selector");

    private GoalDebugPayload(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBlockPos(), buf.readList(DebugGoal::new));
    }

    private void write(FriendlyByteBuf buf2) {
        buf2.writeInt(this.entityId);
        buf2.writeBlockPos(this.pos);
        buf2.writeCollection(this.goals, (buf, goal) -> goal.write((FriendlyByteBuf)((Object)buf)));
    }

    @Override
    public CustomPacketPayload.Type<GoalDebugPayload> type() {
        return TYPE;
    }

    public record DebugGoal(int priority, boolean isRunning, String name) {
        public DebugGoal(FriendlyByteBuf buf) {
            this(buf.readInt(), buf.readBoolean(), buf.readUtf(255));
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeInt(this.priority);
            buf.writeBoolean(this.isRunning);
            buf.writeUtf(this.name);
        }
    }
}

