/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.destroystokyo.paper.antixray.ChunkPacketInfo;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.annotation.DoNotUse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;

public class ClientboundLevelChunkPacketData {
    private static final int TWO_MEGABYTES = 0x200000;
    private final CompoundTag heightmaps;
    private final byte[] buffer;
    private final List<BlockEntityInfo> blockEntitiesData;
    private final List<Packet<?>> extraPackets = new ArrayList();
    private static final int TE_LIMIT = Integer.getInteger("Paper.excessiveTELimit", 750);

    public List<Packet<?>> getExtraPackets() {
        return this.extraPackets;
    }

    @Deprecated
    @DoNotUse
    public ClientboundLevelChunkPacketData(LevelChunk chunk) {
        this(chunk, null);
    }

    public ClientboundLevelChunkPacketData(LevelChunk chunk, ChunkPacketInfo<BlockState> chunkPacketInfo) {
        this.heightmaps = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> entry : chunk.getHeightmaps()) {
            if (!entry.getKey().sendToClient()) continue;
            this.heightmaps.put(entry.getKey().getSerializationKey(), new LongArrayTag(entry.getValue().getRawData()));
        }
        this.buffer = new byte[ClientboundLevelChunkPacketData.calculateChunkSize(chunk)];
        if (chunkPacketInfo != null) {
            chunkPacketInfo.setBuffer(this.buffer);
        }
        ClientboundLevelChunkPacketData.extractChunkData(new FriendlyByteBuf(this.getWriteBuffer()), chunk, chunkPacketInfo);
        this.blockEntitiesData = Lists.newArrayList();
        int totalTileEntities = 0;
        for (Map.Entry<BlockPos, BlockEntity> entry2 : chunk.getBlockEntities().entrySet()) {
            Packet<ClientGamePacketListener> packet;
            if (++totalTileEntities > TE_LIMIT && (packet = entry2.getValue().getUpdatePacket()) != null) {
                this.extraPackets.add(packet);
                continue;
            }
            this.blockEntitiesData.add(BlockEntityInfo.create(entry2.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(RegistryFriendlyByteBuf buf, int x, int z) {
        this.heightmaps = buf.readNbt();
        if (this.heightmaps == null) {
            throw new RuntimeException("Can't read heightmap in packet for [" + x + ", " + z + "]");
        }
        int i = buf.readVarInt();
        if (i > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.buffer = new byte[i];
        buf.readBytes(this.buffer);
        this.blockEntitiesData = (List)BlockEntityInfo.LIST_STREAM_CODEC.decode(buf);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeNbt(this.heightmaps);
        buf.writeVarInt(this.buffer.length);
        buf.writeBytes(this.buffer);
        BlockEntityInfo.LIST_STREAM_CODEC.encode(buf, this.blockEntitiesData);
    }

    private static int calculateChunkSize(LevelChunk chunk) {
        int i = 0;
        for (LevelChunkSection levelChunkSection : chunk.getSections()) {
            i += levelChunkSection.getSerializedSize();
        }
        return i;
    }

    private ByteBuf getWriteBuffer() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.buffer);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    @Deprecated
    @DoNotUse
    public static void extractChunkData(FriendlyByteBuf buf, LevelChunk chunk) {
        ClientboundLevelChunkPacketData.extractChunkData(buf, chunk, null);
    }

    public static void extractChunkData(FriendlyByteBuf buf, LevelChunk chunk, ChunkPacketInfo<BlockState> chunkPacketInfo) {
        int chunkSectionIndex = 0;
        for (LevelChunkSection levelChunkSection : chunk.getSections()) {
            levelChunkSection.write(buf, chunkPacketInfo, chunkSectionIndex);
            ++chunkSectionIndex;
        }
    }

    public Consumer<BlockEntityTagOutput> getBlockEntitiesTagsConsumer(int x, int z) {
        return visitor -> this.getBlockEntitiesTags((BlockEntityTagOutput)visitor, x, z);
    }

    private void getBlockEntitiesTags(BlockEntityTagOutput consumer, int x, int z) {
        int i = 16 * x;
        int j = 16 * z;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (BlockEntityInfo blockEntityInfo : this.blockEntitiesData) {
            int k = i + SectionPos.sectionRelative(blockEntityInfo.packedXZ >> 4);
            int l = j + SectionPos.sectionRelative(blockEntityInfo.packedXZ);
            mutableBlockPos.set(k, blockEntityInfo.y, l);
            consumer.accept(mutableBlockPos, blockEntityInfo.type, blockEntityInfo.tag);
        }
    }

    public FriendlyByteBuf getReadBuffer() {
        return new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.buffer));
    }

    public CompoundTag getHeightmaps() {
        return this.heightmaps;
    }

    static class BlockEntityInfo {
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockEntityInfo> STREAM_CODEC = StreamCodec.ofMember(BlockEntityInfo::write, BlockEntityInfo::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<BlockEntityInfo>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
        final int packedXZ;
        final int y;
        final BlockEntityType<?> type;
        @Nullable
        final CompoundTag tag;

        private BlockEntityInfo(int localXz, int y, BlockEntityType<?> type, @Nullable CompoundTag nbt) {
            this.packedXZ = localXz;
            this.y = y;
            this.type = type;
            this.tag = nbt;
        }

        private BlockEntityInfo(RegistryFriendlyByteBuf buf) {
            this.packedXZ = buf.readByte();
            this.y = buf.readShort();
            this.type = (BlockEntityType)ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE).decode(buf);
            this.tag = buf.readNbt();
        }

        private void write(RegistryFriendlyByteBuf buf) {
            buf.writeByte(this.packedXZ);
            buf.writeShort(this.y);
            ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE).encode(buf, this.type);
            buf.writeNbt(this.tag);
        }

        static BlockEntityInfo create(BlockEntity blockEntity) {
            CompoundTag compoundTag = blockEntity.getUpdateTag(blockEntity.getLevel().registryAccess());
            BlockPos blockPos = blockEntity.getBlockPos();
            int i = SectionPos.sectionRelative(blockPos.getX()) << 4 | SectionPos.sectionRelative(blockPos.getZ());
            blockEntity.sanitizeSentNbt(compoundTag);
            return new BlockEntityInfo(i, blockPos.getY(), blockEntity.getType(), compoundTag.isEmpty() ? null : compoundTag);
        }
    }

    @FunctionalInterface
    public static interface BlockEntityTagOutput {
        public void accept(BlockPos var1, BlockEntityType<?> var2, @Nullable CompoundTag var3);
    }
}

