/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.RecipeBookSettings;

public class ClientboundRecipePacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundRecipePacket> STREAM_CODEC = Packet.codec(ClientboundRecipePacket::write, ClientboundRecipePacket::new);
    private final State state;
    private final List<ResourceLocation> recipes;
    private final List<ResourceLocation> toHighlight;
    private final RecipeBookSettings bookSettings;

    public ClientboundRecipePacket(State action, Collection<ResourceLocation> recipeIdsToChange, Collection<ResourceLocation> recipeIdsToInit, RecipeBookSettings options) {
        this.state = action;
        this.recipes = ImmutableList.copyOf(recipeIdsToChange);
        this.toHighlight = ImmutableList.copyOf(recipeIdsToInit);
        this.bookSettings = options;
    }

    private ClientboundRecipePacket(FriendlyByteBuf buf) {
        this.state = buf.readEnum(State.class);
        this.bookSettings = RecipeBookSettings.read(buf);
        this.recipes = buf.readList(FriendlyByteBuf::readResourceLocation);
        this.toHighlight = this.state == State.INIT ? buf.readList(FriendlyByteBuf::readResourceLocation) : ImmutableList.of();
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeEnum(this.state);
        this.bookSettings.write(buf);
        buf.writeCollection(this.recipes, FriendlyByteBuf::writeResourceLocation);
        if (this.state == State.INIT) {
            buf.writeCollection(this.toHighlight, FriendlyByteBuf::writeResourceLocation);
        }
    }

    @Override
    @Override
    public PacketType<ClientboundRecipePacket> type() {
        return GamePacketTypes.CLIENTBOUND_RECIPE;
    }

    @Override
    @Override
    public void handle(ClientGamePacketListener listener) {
        listener.handleAddOrRemoveRecipes(this);
    }

    public List<ResourceLocation> getRecipes() {
        return this.recipes;
    }

    public List<ResourceLocation> getHighlights() {
        return this.toHighlight;
    }

    public RecipeBookSettings getBookSettings() {
        return this.bookSettings;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        INIT,
        ADD,
        REMOVE;

    }
}

