/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;

public class ClientboundRemoveEntitiesPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundRemoveEntitiesPacket> STREAM_CODEC = Packet.codec(ClientboundRemoveEntitiesPacket::write, ClientboundRemoveEntitiesPacket::new);
    private final IntList entityIds;

    public ClientboundRemoveEntitiesPacket(IntList entityIds) {
        this.entityIds = new IntArrayList(entityIds);
    }

    public ClientboundRemoveEntitiesPacket(int ... entityIds) {
        this.entityIds = new IntArrayList(entityIds);
    }

    private ClientboundRemoveEntitiesPacket(FriendlyByteBuf buf) {
        this.entityIds = buf.readIntIdList();
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeIntIdList(this.entityIds);
    }

    @Override
    @Override
    public PacketType<ClientboundRemoveEntitiesPacket> type() {
        return GamePacketTypes.CLIENTBOUND_REMOVE_ENTITIES;
    }

    @Override
    @Override
    public void handle(ClientGamePacketListener listener) {
        listener.handleRemoveEntities(this);
    }

    public IntList getEntityIds() {
        return this.entityIds;
    }
}

