/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.FileUtil;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerAdvancements {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PlayerList playerList;
    private final Path playerSavePath;
    private AdvancementTree tree;
    private final Map<AdvancementHolder, AdvancementProgress> progress = new LinkedHashMap<AdvancementHolder, AdvancementProgress>();
    private final Set<AdvancementHolder> visible = new HashSet<AdvancementHolder>();
    private final Set<AdvancementHolder> progressChanged = new HashSet<AdvancementHolder>();
    private final Set<AdvancementNode> rootsToUpdate = new HashSet<AdvancementNode>();
    private ServerPlayer player;
    @Nullable
    private AdvancementHolder lastSelectedTab;
    private boolean isFirstPacket = true;
    private final Codec<Data> codec;
    public final Map<SimpleCriterionTrigger<?>, Set<CriterionTrigger.Listener<?>>> criterionData = new IdentityHashMap();

    public PlayerAdvancements(DataFixer dataFixer, PlayerList playerManager, ServerAdvancementManager advancementLoader, Path filePath, ServerPlayer owner) {
        this.playerList = playerManager;
        this.playerSavePath = filePath;
        this.player = owner;
        this.tree = advancementLoader.tree();
        boolean flag = true;
        this.codec = DataFixTypes.ADVANCEMENTS.wrapCodec(Data.CODEC, dataFixer, 1343);
        this.load(advancementLoader);
    }

    public void setPlayer(ServerPlayer owner) {
        this.player = owner;
    }

    public void stopListening() {
        for (CriterionTrigger criterionTrigger : BuiltInRegistries.TRIGGER_TYPES) {
            criterionTrigger.removePlayerListeners(this);
        }
    }

    public void reload(ServerAdvancementManager advancementLoader) {
        this.stopListening();
        this.progress.clear();
        this.visible.clear();
        this.rootsToUpdate.clear();
        this.progressChanged.clear();
        this.isFirstPacket = true;
        this.lastSelectedTab = null;
        this.tree = advancementLoader.tree();
        this.load(advancementLoader);
    }

    private void registerListeners(ServerAdvancementManager advancementLoader) {
        for (AdvancementHolder advancementholder : advancementLoader.getAllAdvancements()) {
            this.registerListeners(advancementholder);
        }
    }

    private void checkForAutomaticTriggers(ServerAdvancementManager advancementLoader) {
        for (AdvancementHolder advancementholder : advancementLoader.getAllAdvancements()) {
            Advancement advancement = advancementholder.value();
            if (!advancement.criteria().isEmpty()) continue;
            this.award(advancementholder, "");
            advancement.rewards().grant(this.player);
        }
    }

    private void load(ServerAdvancementManager advancementLoader) {
        if (Files.isRegularFile(this.playerSavePath, new LinkOption[0])) {
            try (JsonReader jsonreader = new JsonReader((Reader)Files.newBufferedReader(this.playerSavePath, StandardCharsets.UTF_8));){
                jsonreader.setLenient(false);
                JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
                Data advancementdataplayer_a = (Data)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonParseException::new);
                this.applyFrom(advancementLoader, advancementdataplayer_a);
            }
            catch (JsonIOException | IOException ioexception) {
                LOGGER.error("Couldn't access player advancements in {}", (Object)this.playerSavePath, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                LOGGER.error("Couldn't parse player advancements in {}", (Object)this.playerSavePath, (Object)jsonparseexception);
            }
        }
        this.checkForAutomaticTriggers(advancementLoader);
        this.registerListeners(advancementLoader);
    }

    public void save() {
        if (SpigotConfig.disableAdvancementSaving) {
            return;
        }
        JsonElement jsonelement = (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.asData()).getOrThrow();
        try {
            FileUtil.createDirectoriesSafe(this.playerSavePath.getParent());
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(this.playerSavePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson(jsonelement, GSON.newJsonWriter((Writer)bufferedwriter));
            }
        }
        catch (JsonIOException | IOException ioexception) {
            LOGGER.error("Couldn't save player advancements to {}", (Object)this.playerSavePath, (Object)ioexception);
        }
    }

    private void applyFrom(ServerAdvancementManager loader, Data progressMap) {
        progressMap.forEach((minecraftkey, advancementprogress) -> {
            AdvancementHolder advancementholder = loader.get((ResourceLocation)minecraftkey);
            if (advancementholder == null) {
                if (!minecraftkey.getNamespace().equals("minecraft")) {
                    return;
                }
                LOGGER.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", minecraftkey, (Object)this.playerSavePath);
            } else {
                this.startProgress(advancementholder, (AdvancementProgress)advancementprogress);
                this.progressChanged.add(advancementholder);
                this.markForVisibilityUpdate(advancementholder);
            }
        });
    }

    private Data asData() {
        LinkedHashMap<ResourceLocation, AdvancementProgress> map = new LinkedHashMap<ResourceLocation, AdvancementProgress>();
        this.progress.forEach((advancementholder, advancementprogress) -> {
            if (advancementprogress.hasProgress()) {
                map.put(advancementholder.id(), (AdvancementProgress)advancementprogress);
            }
        });
        return new Data(map);
    }

    public boolean award(AdvancementHolder advancement, String criterionName) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.getOrStartProgress(advancement);
        boolean flag1 = advancementprogress.isDone();
        if (advancementprogress.grantProgress(criterionName)) {
            if (!new PlayerAdvancementCriterionGrantEvent((Player)this.player.getBukkitEntity(), advancement.toBukkit(), criterionName).callEvent()) {
                advancementprogress.revokeProgress(criterionName);
                return false;
            }
            this.unregisterListeners(advancement);
            this.progressChanged.add(advancement);
            flag = true;
            if (!flag1 && advancementprogress.isDone()) {
                Component message = advancement.value().display().flatMap(info -> Optional.ofNullable(info.shouldAnnounceChat() ? PaperAdventure.asAdventure(info.getType().createAnnouncement(advancement, this.player)) : null)).orElse(null);
                PlayerAdvancementDoneEvent event = new PlayerAdvancementDoneEvent((Player)this.player.getBukkitEntity(), advancement.toBukkit(), message);
                this.player.level().getCraftServer().getPluginManager().callEvent((Event)event);
                advancement.value().rewards().grant(this.player);
                advancement.value().display().ifPresent(advancementdisplay -> {
                    if (event.message() != null && this.player.level().getGameRules().getBoolean(GameRules.RULE_ANNOUNCE_ADVANCEMENTS)) {
                        this.playerList.broadcastSystemMessage(PaperAdventure.asVanilla(event.message()), false);
                    }
                });
            }
        }
        if (!flag1 && advancementprogress.isDone()) {
            this.markForVisibilityUpdate(advancement);
        }
        return flag;
    }

    public boolean revoke(AdvancementHolder advancement, String criterionName) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.getOrStartProgress(advancement);
        boolean flag1 = advancementprogress.isDone();
        if (advancementprogress.revokeProgress(criterionName)) {
            this.registerListeners(advancement);
            this.progressChanged.add(advancement);
            flag = true;
        }
        if (flag1 && !advancementprogress.isDone()) {
            this.markForVisibilityUpdate(advancement);
        }
        return flag;
    }

    private void markForVisibilityUpdate(AdvancementHolder advancement) {
        AdvancementNode advancementnode = this.tree.get(advancement);
        if (advancementnode != null) {
            this.rootsToUpdate.add(advancementnode.root());
        }
    }

    private void registerListeners(AdvancementHolder advancement) {
        AdvancementProgress advancementprogress = this.getOrStartProgress(advancement);
        if (!advancementprogress.isDone()) {
            for (Map.Entry<String, Criterion<?>> entry : advancement.value().criteria().entrySet()) {
                CriterionProgress criterionprogress = advancementprogress.getCriterion(entry.getKey());
                if (criterionprogress == null || criterionprogress.isDone()) continue;
                this.registerListener(advancement, entry.getKey(), entry.getValue());
            }
        }
    }

    private <T extends CriterionTriggerInstance> void registerListener(AdvancementHolder advancement, String id, Criterion<T> criterion) {
        criterion.trigger().addPlayerListener(this, new CriterionTrigger.Listener<T>(criterion.triggerInstance(), advancement, id));
    }

    private void unregisterListeners(AdvancementHolder advancement) {
        AdvancementProgress advancementprogress = this.getOrStartProgress(advancement);
        for (Map.Entry<String, Criterion<?>> entry : advancement.value().criteria().entrySet()) {
            CriterionProgress criterionprogress = advancementprogress.getCriterion(entry.getKey());
            if (criterionprogress == null || !criterionprogress.isDone() && !advancementprogress.isDone()) continue;
            this.removeListener(advancement, entry.getKey(), entry.getValue());
        }
    }

    private <T extends CriterionTriggerInstance> void removeListener(AdvancementHolder advancement, String id, Criterion<T> criterion) {
        criterion.trigger().removePlayerListener(this, new CriterionTrigger.Listener<T>(criterion.triggerInstance(), advancement, id));
    }

    public void flushDirty(ServerPlayer player) {
        if (this.isFirstPacket || !this.rootsToUpdate.isEmpty() || !this.progressChanged.isEmpty()) {
            HashMap<ResourceLocation, AdvancementProgress> map = new HashMap<ResourceLocation, AdvancementProgress>();
            HashSet<AdvancementHolder> set = new HashSet<AdvancementHolder>();
            HashSet<ResourceLocation> set1 = new HashSet<ResourceLocation>();
            for (AdvancementNode advancementnode : this.rootsToUpdate) {
                this.updateTreeVisibility(advancementnode, set, set1);
            }
            this.rootsToUpdate.clear();
            for (AdvancementHolder advancementholder : this.progressChanged) {
                if (!this.visible.contains(advancementholder)) continue;
                map.put(advancementholder.id(), this.progress.get(advancementholder));
            }
            this.progressChanged.clear();
            if (!(map.isEmpty() && set.isEmpty() && set1.isEmpty())) {
                player.connection.send(new ClientboundUpdateAdvancementsPacket(this.isFirstPacket, set, set1, map));
            }
        }
        this.isFirstPacket = false;
    }

    public void setSelectedTab(@Nullable AdvancementHolder advancement) {
        AdvancementHolder advancementholder1 = this.lastSelectedTab;
        this.lastSelectedTab = advancement != null && advancement.value().isRoot() && advancement.value().display().isPresent() ? advancement : null;
        if (advancementholder1 != this.lastSelectedTab) {
            this.player.connection.send(new ClientboundSelectAdvancementsTabPacket(this.lastSelectedTab == null ? null : this.lastSelectedTab.id()));
        }
    }

    public AdvancementProgress getOrStartProgress(AdvancementHolder advancement) {
        AdvancementProgress advancementprogress = this.progress.get(advancement);
        if (advancementprogress == null) {
            advancementprogress = new AdvancementProgress();
            this.startProgress(advancement, advancementprogress);
        }
        return advancementprogress;
    }

    private void startProgress(AdvancementHolder advancement, AdvancementProgress progress) {
        progress.update(advancement.value().requirements());
        this.progress.put(advancement, progress);
    }

    private void updateTreeVisibility(AdvancementNode root, Set<AdvancementHolder> added, Set<ResourceLocation> removed) {
        AdvancementVisibilityEvaluator.evaluateVisibility(root, advancementnode1 -> this.getOrStartProgress(advancementnode1.holder()).isDone(), (advancementnode1, flag) -> {
            AdvancementHolder advancementholder = advancementnode1.holder();
            if (flag) {
                if (this.visible.add(advancementholder)) {
                    added.add(advancementholder);
                    if (this.progress.containsKey(advancementholder)) {
                        this.progressChanged.add(advancementholder);
                    }
                }
            } else if (this.visible.remove(advancementholder)) {
                removed.add(advancementholder.id());
            }
        });
    }

    private record Data(Map<ResourceLocation, AdvancementProgress> map) {
        public static final Codec<Data> CODEC = Codec.unboundedMap(ResourceLocation.CODEC, AdvancementProgress.CODEC).xmap(Data::new, Data::map);

        public void forEach(BiConsumer<ResourceLocation, AdvancementProgress> consumer) {
            this.map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach((? super T entry) -> consumer.accept((ResourceLocation)entry.getKey(), (AdvancementProgress)entry.getValue()));
        }
    }
}

