/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;

public class BossBarCommands {
    private static final DynamicCommandExceptionType ERROR_ALREADY_EXISTS = new DynamicCommandExceptionType(name -> Component.translatableEscape("commands.bossbar.create.failed", name));
    private static final DynamicCommandExceptionType ERROR_DOESNT_EXIST = new DynamicCommandExceptionType(name -> Component.translatableEscape("commands.bossbar.unknown", name));
    private static final SimpleCommandExceptionType ERROR_NO_PLAYER_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.players.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_NAME_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.name.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_COLOR_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.color.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_STYLE_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.style.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_VALUE_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.value.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_MAX_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.max.unchanged"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_HIDDEN = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.visibility.unchanged.hidden"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_VISIBLE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.visibility.unchanged.visible"));
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_BOSS_BAR = (context, builder) -> SharedSuggestionProvider.suggestResource(((CommandSourceStack)context.getSource()).getServer().getCustomBossEvents().getIds(), builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("bossbar").requires(source -> source.hasPermission(2))).then(Commands.literal("add").then(Commands.argument("id", ResourceLocationArgument.id()).then(Commands.argument("name", ComponentArgument.textComponent(registryAccess)).executes(context -> BossBarCommands.createBar((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "id"), ComponentArgument.getComponent((CommandContext<CommandSourceStack>)context, "name"))))))).then(Commands.literal("remove").then(Commands.argument("id", ResourceLocationArgument.id()).suggests(SUGGEST_BOSS_BAR).executes(context -> BossBarCommands.removeBar((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context)))))).then(Commands.literal("list").executes(context -> BossBarCommands.listBars((CommandSourceStack)context.getSource())))).then(Commands.literal("set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(SUGGEST_BOSS_BAR).then(Commands.literal("name").then(Commands.argument("name", ComponentArgument.textComponent(registryAccess)).executes(context -> BossBarCommands.setName((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), ComponentArgument.getComponent((CommandContext<CommandSourceStack>)context, "name")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("color").then(Commands.literal("pink").executes(context -> BossBarCommands.setColor((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarColor.PINK)))).then(Commands.literal("blue").executes(context -> BossBarCommands.setColor((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarColor.BLUE)))).then(Commands.literal("red").executes(context -> BossBarCommands.setColor((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarColor.RED)))).then(Commands.literal("green").executes(context -> BossBarCommands.setColor((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarColor.GREEN)))).then(Commands.literal("yellow").executes(context -> BossBarCommands.setColor((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarColor.YELLOW)))).then(Commands.literal("purple").executes(context -> BossBarCommands.setColor((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarColor.PURPLE)))).then(Commands.literal("white").executes(context -> BossBarCommands.setColor((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarColor.WHITE))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("style").then(Commands.literal("progress").executes(context -> BossBarCommands.setStyle((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarOverlay.PROGRESS)))).then(Commands.literal("notched_6").executes(context -> BossBarCommands.setStyle((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarOverlay.NOTCHED_6)))).then(Commands.literal("notched_10").executes(context -> BossBarCommands.setStyle((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarOverlay.NOTCHED_10)))).then(Commands.literal("notched_12").executes(context -> BossBarCommands.setStyle((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarOverlay.NOTCHED_12)))).then(Commands.literal("notched_20").executes(context -> BossBarCommands.setStyle((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BossEvent.BossBarOverlay.NOTCHED_20))))).then(Commands.literal("value").then(Commands.argument("value", IntegerArgumentType.integer((int)0)).executes(context -> BossBarCommands.setValue((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(Commands.literal("max").then(Commands.argument("max", IntegerArgumentType.integer((int)1)).executes(context -> BossBarCommands.setMax((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), IntegerArgumentType.getInteger((CommandContext)context, (String)"max")))))).then(Commands.literal("visible").then(Commands.argument("visible", BoolArgumentType.bool()).executes(context -> BossBarCommands.setVisible((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), BoolArgumentType.getBool((CommandContext)context, (String)"visible")))))).then(((LiteralArgumentBuilder)Commands.literal("players").executes(context -> BossBarCommands.setPlayers((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), Collections.emptyList()))).then(Commands.argument("targets", EntityArgument.players()).executes(context -> BossBarCommands.setPlayers((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), EntityArgument.getOptionalPlayers((CommandContext<CommandSourceStack>)context, "targets")))))))).then(Commands.literal("get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(SUGGEST_BOSS_BAR).then(Commands.literal("value").executes(context -> BossBarCommands.getValue((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context))))).then(Commands.literal("max").executes(context -> BossBarCommands.getMax((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context))))).then(Commands.literal("visible").executes(context -> BossBarCommands.getVisible((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context))))).then(Commands.literal("players").executes(context -> BossBarCommands.getPlayers((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context))))))));
    }

    private static int getValue(CommandSourceStack source, CustomBossEvent bossBar) {
        source.sendSuccess(() -> Component.translatable("commands.bossbar.get.value", bossBar.getDisplayName(), bossBar.getValue()), true);
        return bossBar.getValue();
    }

    private static int getMax(CommandSourceStack source, CustomBossEvent bossBar) {
        source.sendSuccess(() -> Component.translatable("commands.bossbar.get.max", bossBar.getDisplayName(), bossBar.getMax()), true);
        return bossBar.getMax();
    }

    private static int getVisible(CommandSourceStack source, CustomBossEvent bossBar) {
        if (bossBar.isVisible()) {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.get.visible.visible", bossBar.getDisplayName()), true);
            return 1;
        }
        source.sendSuccess(() -> Component.translatable("commands.bossbar.get.visible.hidden", bossBar.getDisplayName()), true);
        return 0;
    }

    private static int getPlayers(CommandSourceStack source, CustomBossEvent bossBar) {
        if (bossBar.getPlayers().isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.get.players.none", bossBar.getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.get.players.some", bossBar.getDisplayName(), bossBar.getPlayers().size(), ComponentUtils.formatList(bossBar.getPlayers(), Player::getDisplayName)), true);
        }
        return bossBar.getPlayers().size();
    }

    private static int setVisible(CommandSourceStack source, CustomBossEvent bossBar, boolean visible) throws CommandSyntaxException {
        if (bossBar.isVisible() == visible) {
            if (visible) {
                throw ERROR_ALREADY_VISIBLE.create();
            }
            throw ERROR_ALREADY_HIDDEN.create();
        }
        bossBar.setVisible(visible);
        if (visible) {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.set.visible.success.visible", bossBar.getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.set.visible.success.hidden", bossBar.getDisplayName()), true);
        }
        return 0;
    }

    private static int setValue(CommandSourceStack source, CustomBossEvent bossBar, int value) throws CommandSyntaxException {
        if (bossBar.getValue() == value) {
            throw ERROR_NO_VALUE_CHANGE.create();
        }
        bossBar.setValue(value);
        source.sendSuccess(() -> Component.translatable("commands.bossbar.set.value.success", bossBar.getDisplayName(), value), true);
        return value;
    }

    private static int setMax(CommandSourceStack source, CustomBossEvent bossBar, int value) throws CommandSyntaxException {
        if (bossBar.getMax() == value) {
            throw ERROR_NO_MAX_CHANGE.create();
        }
        bossBar.setMax(value);
        source.sendSuccess(() -> Component.translatable("commands.bossbar.set.max.success", bossBar.getDisplayName(), value), true);
        return value;
    }

    private static int setColor(CommandSourceStack source, CustomBossEvent bossBar, BossEvent.BossBarColor color) throws CommandSyntaxException {
        if (bossBar.getColor().equals((Object)color)) {
            throw ERROR_NO_COLOR_CHANGE.create();
        }
        bossBar.setColor(color);
        source.sendSuccess(() -> Component.translatable("commands.bossbar.set.color.success", bossBar.getDisplayName()), true);
        return 0;
    }

    private static int setStyle(CommandSourceStack source, CustomBossEvent bossBar, BossEvent.BossBarOverlay style) throws CommandSyntaxException {
        if (bossBar.getOverlay().equals((Object)style)) {
            throw ERROR_NO_STYLE_CHANGE.create();
        }
        bossBar.setOverlay(style);
        source.sendSuccess(() -> Component.translatable("commands.bossbar.set.style.success", bossBar.getDisplayName()), true);
        return 0;
    }

    private static int setName(CommandSourceStack source, CustomBossEvent bossBar, Component name) throws CommandSyntaxException {
        MutableComponent component = ComponentUtils.updateForEntity(source, name, null, 0);
        if (bossBar.getName().equals(component)) {
            throw ERROR_NO_NAME_CHANGE.create();
        }
        bossBar.setName(component);
        source.sendSuccess(() -> Component.translatable("commands.bossbar.set.name.success", bossBar.getDisplayName()), true);
        return 0;
    }

    private static int setPlayers(CommandSourceStack source, CustomBossEvent bossBar, Collection<ServerPlayer> players) throws CommandSyntaxException {
        boolean bl = bossBar.setPlayers(players);
        if (!bl) {
            throw ERROR_NO_PLAYER_CHANGE.create();
        }
        if (bossBar.getPlayers().isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.set.players.success.none", bossBar.getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.set.players.success.some", bossBar.getDisplayName(), players.size(), ComponentUtils.formatList(players, Player::getDisplayName)), true);
        }
        return bossBar.getPlayers().size();
    }

    private static int listBars(CommandSourceStack source) {
        Collection<CustomBossEvent> collection = source.getServer().getCustomBossEvents().getEvents();
        if (collection.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.list.bars.none"), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.bossbar.list.bars.some", collection.size(), ComponentUtils.formatList(collection, CustomBossEvent::getDisplayName)), false);
        }
        return collection.size();
    }

    private static int createBar(CommandSourceStack source, ResourceLocation name, Component displayName) throws CommandSyntaxException {
        CustomBossEvents customBossEvents = source.getServer().getCustomBossEvents();
        if (customBossEvents.get(name) != null) {
            throw ERROR_ALREADY_EXISTS.create((Object)name.toString());
        }
        CustomBossEvent customBossEvent = customBossEvents.create(name, ComponentUtils.updateForEntity(source, displayName, null, 0));
        source.sendSuccess(() -> Component.translatable("commands.bossbar.create.success", customBossEvent.getDisplayName()), true);
        return customBossEvents.getEvents().size();
    }

    private static int removeBar(CommandSourceStack source, CustomBossEvent bossBar) {
        CustomBossEvents customBossEvents = source.getServer().getCustomBossEvents();
        bossBar.removeAllPlayers();
        customBossEvents.remove(bossBar);
        source.sendSuccess(() -> Component.translatable("commands.bossbar.remove.success", bossBar.getDisplayName()), true);
        return customBossEvents.getEvents().size();
    }

    public static CustomBossEvent getBossBar(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceLocationArgument.getId(context, "id");
        CustomBossEvent customBossEvent = ((CommandSourceStack)context.getSource()).getServer().getCustomBossEvents().get(resourceLocation);
        if (customBossEvent == null) {
            throw ERROR_DOESNT_EXIST.create((Object)resourceLocation.toString());
        }
        return customBossEvent;
    }
}

