/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Consumer;
import net.minecraft.world.level.ChunkPos;

public interface ChunkTrackingView {
    public static final ChunkTrackingView EMPTY = new ChunkTrackingView(){

        @Override
        @Override
        public boolean contains(int x, int z, boolean includeEdge) {
            return false;
        }

        @Override
        @Override
        public void forEach(Consumer<ChunkPos> consumer) {
        }
    };

    public static ChunkTrackingView of(ChunkPos center, int viewDistance) {
        return new Positioned(center, viewDistance);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void difference(ChunkTrackingView oldFilter, ChunkTrackingView newFilter, Consumer<ChunkPos> newlyIncluded, Consumer<ChunkPos> justRemoved) {
        Positioned positioned2;
        Positioned positioned;
        block8: {
            block7: {
                if (oldFilter.equals(newFilter)) {
                    return;
                }
                if (!(oldFilter instanceof Positioned)) break block7;
                positioned = (Positioned)oldFilter;
                if (newFilter instanceof Positioned && positioned.squareIntersects(positioned2 = (Positioned)newFilter)) break block8;
            }
            oldFilter.forEach(justRemoved);
            newFilter.forEach(newlyIncluded);
            return;
        }
        int i = Math.min(positioned.minX(), positioned2.minX());
        int j = Math.min(positioned.minZ(), positioned2.minZ());
        int k = Math.max(positioned.maxX(), positioned2.maxX());
        int l = Math.max(positioned.maxZ(), positioned2.maxZ());
        int m = i;
        while (m <= k) {
            for (int n = j; n <= l; ++n) {
                boolean bl2;
                boolean bl = positioned.contains(m, n);
                if (bl == (bl2 = positioned2.contains(m, n))) continue;
                if (bl2) {
                    newlyIncluded.accept(new ChunkPos(m, n));
                    continue;
                }
                justRemoved.accept(new ChunkPos(m, n));
            }
            ++m;
        }
        return;
    }

    default public boolean contains(ChunkPos pos) {
        return this.contains(pos.x, pos.z);
    }

    default public boolean contains(int x, int z) {
        return this.contains(x, z, true);
    }

    public boolean contains(int var1, int var2, boolean var3);

    public void forEach(Consumer<ChunkPos> var1);

    default public boolean isInViewDistance(int x, int z) {
        return this.contains(x, z, false);
    }

    public static boolean isInViewDistance(int centerX, int centerZ, int viewDistance, int x, int z) {
        return ChunkTrackingView.isWithinDistance(centerX, centerZ, viewDistance, x, z, false);
    }

    public static boolean isWithinDistance(int centerX, int centerZ, int viewDistance, int x, int z, boolean includeEdge) {
        int i = Math.max(0, Math.abs(x - centerX) - 1);
        int j = Math.max(0, Math.abs(z - centerZ) - 1);
        long l = Math.max(0, Math.max(i, j) - (includeEdge ? 1 : 0));
        long m = Math.min(i, j);
        long n = m * m + l * l;
        int k = viewDistance * viewDistance;
        return n < (long)k;
    }

    public record Positioned(ChunkPos center, int viewDistance) implements ChunkTrackingView
    {
        int minX() {
            return this.center.x - this.viewDistance - 1;
        }

        int minZ() {
            return this.center.z - this.viewDistance - 1;
        }

        int maxX() {
            return this.center.x + this.viewDistance + 1;
        }

        int maxZ() {
            return this.center.z + this.viewDistance + 1;
        }

        @VisibleForTesting
        protected boolean squareIntersects(Positioned o) {
            return this.minX() <= o.maxX() && this.maxX() >= o.minX() && this.minZ() <= o.maxZ() && this.maxZ() >= o.minZ();
        }

        @Override
        @Override
        public boolean contains(int x, int z, boolean includeEdge) {
            return ChunkTrackingView.isWithinDistance(this.center.x, this.center.z, this.viewDistance, x, z, includeEdge);
        }

        @Override
        @Override
        public void forEach(Consumer<ChunkPos> consumer) {
            for (int i = this.minX(); i <= this.maxX(); ++i) {
                for (int j = this.minZ(); j <= this.maxZ(); ++j) {
                    if (!this.contains(i, j)) continue;
                    consumer.accept(new ChunkPos(i, j));
                }
            }
        }
    }
}

