/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public abstract class AbstractPackResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;

    protected AbstractPackResources(PackLocationInfo info) {
        this.location = info;
    }

    @Override
    @Nullable
    @Override
    public <T> T getMetadataSection(MetadataSectionSerializer<T> metaReader) throws IOException {
        IoSupplier<InputStream> ioSupplier = this.getRootResource("pack.mcmeta");
        if (ioSupplier == null) {
            return null;
        }
        try (InputStream inputStream = ioSupplier.get();){
            T t = AbstractPackResources.getMetadataFromStream(metaReader, inputStream);
            return t;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T getMetadataFromStream(MetadataSectionSerializer<T> metaReader, InputStream inputStream) {
        void jsonObject3;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            JsonObject jsonObject = GsonHelper.parse(bufferedReader);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load {} metadata", (Object)metaReader.getMetadataSectionName(), (Object)exception);
            return null;
        }
        if (!jsonObject3.has(metaReader.getMetadataSectionName())) {
            return null;
        }
        try {
            return metaReader.fromJson(GsonHelper.getAsJsonObject((JsonObject)jsonObject3, metaReader.getMetadataSectionName()));
        }
        catch (Exception exception2) {
            LOGGER.error("Couldn't load {} metadata", (Object)metaReader.getMetadataSectionName(), (Object)exception2);
            return null;
        }
    }

    @Override
    @Override
    public PackLocationInfo location() {
        return this.location;
    }
}

