/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;

public class CompositePackResources
implements PackResources {
    private final PackResources primaryPackResources;
    private final List<PackResources> packResourcesStack;

    public CompositePackResources(PackResources base, List<PackResources> overlays) {
        this.primaryPackResources = base;
        ArrayList<PackResources> list = new ArrayList<PackResources>(overlays.size() + 1);
        list.addAll(Lists.reverse(overlays));
        list.add(base);
        this.packResourcesStack = List.copyOf(list);
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> getRootResource(String ... segments) {
        return this.primaryPackResources.getRootResource(segments);
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation id) {
        for (PackResources packResources : this.packResourcesStack) {
            IoSupplier<InputStream> ioSupplier = packResources.getResource(type, id);
            if (ioSupplier == null) continue;
            return ioSupplier;
        }
        return null;
    }

    @Override
    @Override
    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        HashMap<ResourceLocation, IoSupplier<InputStream>> map = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
        for (PackResources packResources : this.packResourcesStack) {
            packResources.listResources(type, namespace, prefix, map::putIfAbsent);
        }
        map.forEach(consumer);
    }

    @Override
    @Override
    public Set<String> getNamespaces(PackType type) {
        HashSet<String> set = new HashSet<String>();
        for (PackResources packResources : this.packResourcesStack) {
            set.addAll(packResources.getNamespaces(type));
        }
        return set;
    }

    @Override
    @Nullable
    @Override
    public <T> T getMetadataSection(MetadataSectionSerializer<T> metaReader) throws IOException {
        return this.primaryPackResources.getMetadataSection(metaReader);
    }

    @Override
    @Override
    public PackLocationInfo location() {
        return this.primaryPackResources.location();
    }

    @Override
    @Override
    public void close() {
        this.packResourcesStack.forEach(PackResources::close);
    }
}

